/**
 * Project Name:activity-center-api
 * File Name:RemoteTodayRobConfigService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.rob
 * Date:2016年7月25日下午3:21:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.littlegame;


import cn.com.duiba.activity.center.api.dto.littlegame.LittleGameDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 小游戏类型 activity-center dubbo接口
 * @author  : cdm
 * @date    : 2016年10月13日 下午2:44:02
 */
public interface RemoteLittleGameService {
	
	
	/**
	 * describe : 根据ID查询游戏信息
	 * @author  : cdm
	 * @date    : 2016年10月13日下午4:32:18
	 * @param LittleGameId   游戏ID
	 */
    DubboResult<LittleGameDto> getLittleGameById(Long LittleGameId);
    
    /**
     * 中奖接口，中奖减库存等 ，暂时写在activity-center  理由： 时间不不足
     * @since JDK 1.6
     */
    public DubboResult<String> haveGift(Long littleGameId, String orderNum, ActivityPrizeOptionDto winOption,String ip);
}

