package cn.com.duiba.activity.center.api.dto.creditgame;

import java.io.Serializable;
import java.util.Date;

/**
 * 加积分异常记录实体传输类
 * @author jyc
 * @since 2016-09-05
 */
public class AddCreditExceptionRecordDto implements Serializable{

    private static final long serialVersionUID = 1L;
    
    public static final byte Exception_Type_Failure = 0;
    public static final byte Exception_Type_Unknown = 1;

    private Long id;

    /**
     * 兑吧订单
     */
    private String orderNum;
    
    /**
     * 来源app
     */
    private Long appId;

    /**
     * 加积分数量
     */
    private Long addCreditNum;

    /**
     * 加积分类型(1:积分游戏奖项)
     */
    private Long addCreditType;
    
    /**
     * 异常类型(0:失败,1:未知)
     */
    private Byte exceptionType;

    /**
     * 加积分理由
     */
    private String addCreditReason;

    /**
     * 加积分异常说明
     */
    private String addCreditError;

    /**
     * 关闭理由
     */
    private String closeReason;

    /**
     * 关闭状态(0:开启,1:关闭)
     */
    private Byte isClose;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录最后修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
    
    public String getOrderNum() {
        return orderNum;
    }

    
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAddCreditNum() {
        return addCreditNum;
    }

    public void setAddCreditNum(Long addCreditNum) {
        this.addCreditNum = addCreditNum;
    }

    public Long getAddCreditType() {
        return addCreditType;
    }

    public void setAddCreditType(Long addCreditType) {
        this.addCreditType = addCreditType;
    }
    
    public Byte getExceptionType() {
        return exceptionType;
    }
    
    public void setExceptionType(Byte exceptionType) {
        this.exceptionType = exceptionType;
    }

    public String getAddCreditReason() {
        return addCreditReason;
    }

    public void setAddCreditReason(String addCreditReason) {
        this.addCreditReason = addCreditReason == null ? null : addCreditReason.trim();
    }

    public String getAddCreditError() {
        return addCreditError;
    }

    public void setAddCreditError(String addCreditError) {
        this.addCreditError = addCreditError == null ? null : addCreditError.trim();
    }

    public String getCloseReason() {
        return closeReason;
    }

    public void setCloseReason(String closeReason) {
        this.closeReason = closeReason == null ? null : closeReason.trim();
    }

    public Byte getIsClose() {
        return isClose;
    }

    public void setIsClose(Byte isClose) {
        this.isClose = isClose;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}