package cn.com.duiba.activity.center.api.dto.littlegame;

import java.io.Serializable;
import java.util.Date;


/**
 * describe : 小游戏实体Dto
 * @author  : cdm
 * @date    : 2016年10月13日 下午2:46:34
 */
public class LittleGameDto  implements Serializable {

	private static final long serialVersionUID = 66486544211386844L;
	
	public static final int STATUS_OPEN = 1; // 开启且可见
    public static final int STATUS_CLOSE = 3; // 关闭不可见
    
    public static final int SWITCHES_DIRECT = 0;        // 定向发放
    public static final int SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
    public static final int SWITCHES_ANTICHEAT_LIMIT_RULE = 3; // 开启直充类奖品防刷
    
    public static final String FREE_TYPE_FOREVER       = "forever";            // 永久
    public static final String FREE_TYPE_EVERYDAY      = "everyday";           // 每天
    public static final String SHARE                  = "SHARE";
    public static final String PREVIEW                = "PREVIEW";
    
    
    public static final byte IS_BUY = 0; // 付费游戏
    public static final byte IS_NO_BUY = 1; // 非付费游戏

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 标题
     */
    private String littleGameTitle;

    /**
     * 授权页展示：(0 : 关闭  1：开启， 默认 1 )
     */
    private Boolean littleGameType;

    /**
     * 购买价格
     */
    private Long littleGamePrice;
    

    /**
     * 游戏限制类型 everyday:每天,forever:总共
     */
    private String littleGameFreeType;

    /**
     * 免费限制次数
     */
    private Integer littleGameFreeNum;
    
    /**
     * 游戏皮肤关联ID  
     */
    private Long gameSkinId;

    /**
     * 缩略图
     */
    private String littleGameSmallImg;

    /**
     * 白底缩略图
     */
    private String littleGameWhiteImg;
    
    /**
     * icon图
     */
    private String littleGameIconImg;

    /**
     * 首页banner图
     */
    private String littleGameBannerImg;

    /**
     * 游戏授权页规则介绍
     */
    private String littleGameRuleDescribe;

    /**
     * 游戏推荐描述
     */
    private String littleGameRecomDescribe;
    
    /**
     * 游戏推荐图
     */
    private String littleGameRecomImg;

    /**
     * 游戏结束弹层文案
     */
    private String littleGameEndDescribe;
    
    /**
     * 游戏标签
     */
    private String littleGameTag;

    /**
     * 游戏归类(基于子页面)
     */
    private Long littleGameCategoryId;

    /**
     * 游戏状态：1: 开启且可见 ; 2 :关闭且可见;3:关闭不可见
     */
    private Integer littleGameStatus;

    /**
     * 游戏是否删除   0 ：未删除   1：删除
     */
    private Boolean littleGameDelete;
    
    /**
     * 自动关闭时间
     */
    private Date autoOffDate;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录最后修改时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remarks;
    
    
    

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getLittleGameTitle() {
		return littleGameTitle;
	}

	public void setLittleGameTitle(String littleGameTitle) {
		this.littleGameTitle = littleGameTitle;
	}

	public Boolean getLittleGameType() {
		return littleGameType;
	}

	public void setLittleGameType(Boolean littleGameType) {
		this.littleGameType = littleGameType;
	}

	public Long getLittleGamePrice() {
		return littleGamePrice;
	}

	public void setLittleGamePrice(Long littleGamePrice) {
		this.littleGamePrice = littleGamePrice;
	}

	public String getLittleGameFreeType() {
		return littleGameFreeType;
	}

	public void setLittleGameFreeType(String littleGameFreeType) {
		this.littleGameFreeType = littleGameFreeType;
	}

	public Integer getLittleGameFreeNum() {
		return littleGameFreeNum;
	}

	public void setLittleGameFreeNum(Integer littleGameFreeNum) {
		this.littleGameFreeNum = littleGameFreeNum;
	}

	public String getLittleGameSmallImg() {
		return littleGameSmallImg;
	}

	public void setLittleGameSmallImg(String littleGameSmallImg) {
		this.littleGameSmallImg = littleGameSmallImg;
	}

	public String getLittleGameWhiteImg() {
		return littleGameWhiteImg;
	}

	public void setLittleGameWhiteImg(String littleGameWhiteImg) {
		this.littleGameWhiteImg = littleGameWhiteImg;
	}

	public String getLittleGameIconImg() {
		return littleGameIconImg;
	}

	public void setLittleGameIconImg(String littleGameIconImg) {
		this.littleGameIconImg = littleGameIconImg;
	}

	public String getLittleGameBannerImg() {
		return littleGameBannerImg;
	}

	public void setLittleGameBannerImg(String littleGameBannerImg) {
		this.littleGameBannerImg = littleGameBannerImg;
	}

	public String getLittleGameRuleDescribe() {
		return littleGameRuleDescribe;
	}

	public void setLittleGameRuleDescribe(String littleGameRuleDescribe) {
		this.littleGameRuleDescribe = littleGameRuleDescribe;
	}

	public String getLittleGameRecomDescribe() {
		return littleGameRecomDescribe;
	}

	public void setLittleGameRecomDescribe(String littleGameRecomDescribe) {
		this.littleGameRecomDescribe = littleGameRecomDescribe;
	}
	
    public String getLittleGameRecomImg() {
        return littleGameRecomImg;
    }
    
    public void setLittleGameRecomImg(String littleGameRecomImg) {
        this.littleGameRecomImg = littleGameRecomImg;
    }

    public String getLittleGameEndDescribe() {
		return littleGameEndDescribe;
	}

	public void setLittleGameEndDescribe(String littleGameEndDescribe) {
		this.littleGameEndDescribe = littleGameEndDescribe;
	}

	public String getLittleGameTag() {
		return littleGameTag;
	}

	public void setLittleGameTag(String littleGameTag) {
		this.littleGameTag = littleGameTag;
	}

	public Long getLittleGameCategoryId() {
		return littleGameCategoryId;
	}

	public void setLittleGameCategoryId(Long littleGameCategoryId) {
		this.littleGameCategoryId = littleGameCategoryId;
	}

	public Integer getLittleGameStatus() {
		return littleGameStatus;
	}

	public void setLittleGameStatus(Integer littleGameStatus) {
		this.littleGameStatus = littleGameStatus;
	}


	public Boolean getLittleGameDelete() {
		return littleGameDelete;
	}

	public void setLittleGameDelete(Boolean littleGameDelete) {
		this.littleGameDelete = littleGameDelete;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public Long getGameSkinId() {
		return gameSkinId;
	}

	public void setGameSkinId(Long gameSkinId) {
		this.gameSkinId = gameSkinId;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

    @Override
    public String toString() {
        return "LittleGameDto [id=" + id + ", littleGameTitle=" + littleGameTitle + ", littleGameType="
               + littleGameType + ", littleGamePrice=" + littleGamePrice + ", littleGameFreeType=" + littleGameFreeType
               + ", littleGameFreeNum=" + littleGameFreeNum + ", gameSkinId=" + gameSkinId + ", littleGameSmallImg="
               + littleGameSmallImg + ", littleGameWhiteImg=" + littleGameWhiteImg + ", littleGameIconImg="
               + littleGameIconImg + ", littleGameBannerImg=" + littleGameBannerImg + ", littleGameRuleDescribe="
               + littleGameRuleDescribe + ", littleGameRecomDescribe=" + littleGameRecomDescribe
               + ", littleGameRecomImg=" + littleGameRecomImg + ", littleGameEndDescribe=" + littleGameEndDescribe
               + ", littleGameTag=" + littleGameTag + ", littleGameCategoryId=" + littleGameCategoryId
               + ", littleGameStatus=" + littleGameStatus + ", littleGameDelete=" + littleGameDelete + ", autoOffDate="
               + autoOffDate + ", gmtCreate=" + gmtCreate + ", gmtModified=" + gmtModified + ", remarks=" + remarks
               + "]";
    }
}