/**
 * Project Name:activity-center-api
 * File Name:RemoteCreditGameBackendService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.creditgame
 * Date:2016年9月5日下午3:08:23
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.creditgame.QueryParameters;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteCreditGameBackendService <br/>
 * 积分游戏后台 接口
 * Date:     2016年9月5日 下午3:08:23 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteCreditGameBackendService {
    /**
     * 新增游戏
     * @param creditGameDto 积分游戏传输实体
     * @return 积分游戏ID
     */
     DubboResult<Long> addCreditGame(CreditGameDto creditGameDto);
  
   /**
     * 根据游戏Id更新游戏
     * @param gameId 游戏Id
     * @param gameDto 游戏传输实体
     * @return 修改结果 TRUE/FALSE
     */
     DubboResult<Boolean> updateCreditGame(Long id,CreditGameDto creditGameDto);
  
     /**
     * 根据游戏ID获取游戏实体
     * @param creditGameId 游戏ID
     * @return 游戏实体传输实例
     */
     DubboResult<CreditGameDto> getCreditGameByCreditGameId(Long id);
  
   /**
     * 根据查询参数获取游戏实体List
     * TODO 暂不需要，未实现
     * @param queryParameters 查询参数
     * @return 游戏实体传输实例
     */
     DubboResult<List<CreditGameDto>> getGamesByQueryParameters(QueryParameters queryParameters);
  
    /**
     * 根据参数和分页参数获取游戏List
     * @param title 游戏标题
     * @param pagingParameters 分页参数
     *  max+offset or currentPage+pageSize
     * @return 分页游戏实体传输实例
     */
     DubboResult<PaginationDto<CreditGameDto>> getCreditGamesByQueryAndPagingParameters(String title,PagingParameters pagingParameters);
     
     /**
      * 
      * deleteCreditGame:删除积分游戏. <br/>
      *
      * @author wubo
      * @param id
      * @return
      * @since JDK 1.6
      */
     DubboResult<Boolean> deleteCreditGame(Long id);
     
     /**
      * 自动下架
      * autoOff:自动下架的功能. <br/>
      *
      * @author wubo
      * @return
      * @since JDK 1.6
      */
     DubboResult<Integer> autoOff();
}

