package cn.com.duiba.activity.center.api.dto.direct;

import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
 * Created by suyuanlong on 16/7/19.
 * 活动定向功能合并dto。
 * 背景：现在不同的活动定向，都独自走自个不同的一套逻辑。
 *      现在希望把逻辑全并起来。
 */
public class DuibaActivityAppSpecifyNewDto implements Serializable {

    private static final long serialVersionUID = -5363589927681235910L;

    public static Map<String,String> ACTIVITY_TYPE_MAP = Maps.newHashMap();

    public static Map<String,String> ACTIVITY_HD_TYPE_MAP = Maps.newHashMap();


    static {
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_GUESS,DuibaActivityAppSpecifyNewDto.ACTIVITY_GUESS);

        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HDTOOL,DuibaActivityAppSpecifyNewDto.ACTIVITY_HDTOOL);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_MANUALLOTTERY,DuibaActivityAppSpecifyNewDto.ACTIVITY_MANUALLOTTERY);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_NGMAE,DuibaActivityAppSpecifyNewDto.ACTIVITY_NGMAE);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_QUESTION,DuibaActivityAppSpecifyNewDto.ACTIVITY_QUESTION);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_QUIZZ,DuibaActivityAppSpecifyNewDto.ACTIVITY_QUIZZ);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_SECKILL,DuibaActivityAppSpecifyNewDto.ACTIVITY_SECKILL);

        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_SINGLELOTTERY,DuibaActivityAppSpecifyNewDto.ACTIVITY_SINGLELOTTERY);
        ACTIVITY_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_ROB, DuibaActivityAppSpecifyNewDto.ACTIVITY_ROB);

        ACTIVITY_HD_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_SHAKE,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_SHAKE);
        ACTIVITY_HD_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_SCRATCH_CARD,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_SCRATCH_CARD);

        ACTIVITY_HD_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ITGER,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ITGER);
        ACTIVITY_HD_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_TURNTABLE,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_TURNTABLE);

        ACTIVITY_HD_TYPE_MAP.put(DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ROB,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ROB);

        ACTIVITY_TYPE_MAP = Collections.unmodifiableMap(ACTIVITY_TYPE_MAP);
        ACTIVITY_HD_TYPE_MAP = Collections.unmodifiableMap(ACTIVITY_HD_TYPE_MAP);
    }


    public static final String ACTIVITY_GUESS="guess";

    public static final String ACTIVITY_HDTOOL="hdtool";
    public static final String ACTIVITY_MANUALLOTTERY="manuallottery";
    public static final String ACTIVITY_NGMAE="ngame";
    public static final String ACTIVITY_QUESTION="question";
    public static final String ACTIVITY_QUIZZ="quizz";
    public static final String ACTIVITY_SECKILL="seckill";
    public static final String ACTIVITY_SINGLELOTTERY="singlelottery";
    public static final String ACTIVITY_ROB = "rob";


    public static final String ACTIVITY_HD_TYPE_SHAKE = "shake";
    public static final String ACTIVITY_HD_TYPE_SCRATCH_CARD = "scratchCard";
    public static final String ACTIVITY_HD_TYPE_ITGER = "slotMachine";
    public static final String ACTIVITY_HD_TYPE_TURNTABLE = "turntable";
     
    public static final String ACTIVITY_HD_TYPE_ROB = "rob"; 
    public static final String ACTIVITY_HD_TYPE_CREDIT_GAME = "cgame";
    
    private Long id;

    private Long appId;

    /**
     * guess：竞猜
     * hdtool：活动工具
     * manuallottery：手动开奖
     * ngame：新游戏
     * question：答题
     * quizz：测试题
     * seckill：秒杀活动
     * singlelottery：单品抽奖
     */
    private String relationType;

    private Long relationId;

    /**
     * public static final String HD_SHAKE = "shake";
     * public static final String HD_SCRATCH_CARD = "scratchCard";
     * public static final String HD_ITGER = "slotMachine";
     * public static final String HD_TURNTABLE = "turntable"
     */
    private String hdType;

    private Date gmtCreate;

    private Date gmtModified;

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setHdType(String hdType) {
        this.hdType = hdType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }



    public Long getAppId() {
        return appId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getHdType() {
        return hdType;
    }

    public Long getId() {
        return id;
    }

    public Long getRelationId() {
        return relationId;
    }

    public String getRelationType() {
        return relationType;
    }



}
