package cn.com.duiba.activity.center.api.dto.manual;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.activity.center.api.dto.BaseDto;

/**
 * Created by xuezhaoming on 16/6/7.
 */
public class ManualLotteryOrderDto implements Serializable {

	private static final long serialVersionUID = -7261406209554486998L;

	public static final String PREFIX_ORDER             = "manuallottery-";

    public static final int    STATUS_CREATE            = 0;                   // 订单创建
    public static final int    STATUS_SUCCESS           = 1;                   // 订单成功（扣积分成功）
    public static final int    STATUS_FAIL              = 2;                   // 订单失败（扣积分失败）

    public static final int    EXCHANGE_STATUS_CREATE   = 0;                   // 创建
    public static final int    EXCHANGE_STATUS_WAITOPEN = 1;                   // 待开奖
    public static final int    EXCHANGE_STATUS_WIN      = 2;                   // 中奖
    public static final int    EXCHANGE_STATUS_NOTWIN   = 3;                   // 未中奖

    private Long               id;

    private Long               operatingActivityId;

    private Long               appId;

    private Long               consumerId;

    private String             partnerUserId;

    private Long               credits;

    private String             developerBizId;

    private Integer            status;

    private Integer            exchangeStatus;

    private Long               orderId;

    private String             ip;

    private String             phone;

    private Date               winDate;

    private Date               shipDate;

    private String             addressInfo;

    private String             error4admin;

    private String             error4developer;

    private String             error4consumer;

    private Date               gmtCreate;

    private Date               gmtModified;

    public static synchronized String generateOrderNum(Long id) {
        return PREFIX_ORDER + id.toString();
    }

    public ManualLotteryOrderDto() {
    }

    public ManualLotteryOrderDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public ManualLotteryOrderDto(boolean init4insert) {
        if (init4insert) {
            status = 0;
            exchangeStatus = 0;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Date getShipDate() {
        return shipDate;
    }

    public void setShipDate(Date shipDate) {
        this.shipDate = shipDate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getExchangeStatus() {
        return exchangeStatus;
    }

    public void setExchangeStatus(Integer exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getWinDate() {
        return winDate;
    }

    public void setWinDate(Date winDate) {
        this.winDate = winDate;
    }

    public String getAddressInfo() {
        return addressInfo;
    }

    public void setAddressInfo(String addressInfo) {
        this.addressInfo = addressInfo;
    }

    public String getError4admin() {
        return error4admin;
    }

    public void setError4admin(String error4admin) {
        if (error4admin != null && error4admin.length() > 200) {
            error4admin = error4admin.substring(0, 200);
        }
        this.error4admin = error4admin;
    }

    public String getError4developer() {
        return error4developer;
    }

    public void setError4developer(String error4developer) {
        if (error4developer != null && error4developer.length() > 200) {
            error4developer = error4developer.substring(0, 200);
        }
        this.error4developer = error4developer;
    }

    public String getError4consumer() {
        return error4consumer;
    }

    public void setError4consumer(String error4consumer) {
        if (error4consumer != null && error4consumer.length() > 200) {
            error4consumer = error4consumer.substring(0, 200);
        }
        this.error4consumer = error4consumer;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
