package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by houwen on 16/8/11.
 */
public interface RemoteActivityConsumerLimitService {

	/**
	 * 查询用户今日参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久参与参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户今日免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户活动奖项中奖次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public DubboResult<Integer> findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);

	/**
	 * 用户活动奖项中奖次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);

}
