package cn.com.duiba.activity.center.api.dto;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.ActivityTypeEnum;

/**
 * 活动组合类
 * Created by xiaoxuda on 2017/1/22.
 * 注意 ActivityKeyDto 对象自能由活动适配层产生
 */
public class ActivityKeyDto extends BaseDto{

    private static final long serialVersionUID = 7483623387280625952L;

    private ActivityCommonDto activityCommonDto;

    private OperatingActivityDto operatingActivityDto;

    /**
     * 活动类型
     * @return
     */
    public ActivityTypeEnum getType(){
        if(activityCommonDto!=null) {
            return activityCommonDto.getType();
        }
        if(operatingActivityDto!=null){
            return ActivityTypeEnum.getEnumType(operatingActivityDto.getType());
        }
        return null;
    }

    /**
     * 判断活动是否是自有
     * @return
     */
    public Boolean isSelfActivity(){
        if(operatingActivityDto==null){//开发者未上架,一定是兑吧活动
            return false;
        }
        return operatingActivityDto.getActivityId()==null;
    }

    public ActivityCommonDto getActivityCommonDto() {
        return activityCommonDto;
    }

    public void setActivityCommonDto(ActivityCommonDto activityCommonDto) {
        this.activityCommonDto = activityCommonDto;
    }

    public OperatingActivityDto getOperatingActivityDto() {
        return operatingActivityDto;
    }

    public void setOperatingActivityDto(OperatingActivityDto operatingActivityDto) {
        this.operatingActivityDto = operatingActivityDto;
    }
}
