package cn.com.duiba.activity.center.api.enums;

import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.*;

import cn.com.duiba.activity.center.api.exception.ActivityTypeException;

/**
 * @author 刘瑶
 * 活动类型TYPE
 * 新创建的活动工具现在已经全部统一类型,全部换成砸金蛋
 * 但我们约定,WEB不出现具体活动type,兼容逻辑全部在活动中心处理
 * 一种枚举类型对应一个活动库实例
 */
public enum ActivityTypeEnum{

    ACTIVITY_TOOL(TypeHdToolSmashg,"活动工具"),
    ZHANGTI_ACTIVITY(TypeDuibaActivity,"专题活动"),
    QUESTION_ANSWER(TypeDuibaQuestionAnswer,"答题活动"),
    SECONDS_KILL(TypeSecondsKill,"秒杀专题"),
    SECONDS_ACTIVITY(TypeDuibaSeckill,"秒杀活动"),
    QUIZZ(TypeDuibaQuizz,"测试题"),
    GAME(TypeDuibaNgame,"游戏"),
    CREDIT_GAME(TypeDuibaCreditGame,"积分游戏"),
    LITTLE_GAME(TypeDuibaLittleGame,"小游戏"),
    GUESS(TypeDuibaGuess,"竞猜活动"),
    ROB(TypeDuibaRob,"今日必抢"),
    PLUGIN(TypePlugin,"插件活动"),
    SINGLE_LOTTERY(TypeDuibaSingleLottery,"兑吧单品抽奖"),
    APP_SINGLE_LOTTERY(TypeAppSingleLottery,"自有单品抽奖"),
    MANUAL_LOTTERY(TypeAppManualLottery,"手动开奖"),
    SIGN(TypeSign,"签到活动"),
    ELASTIC_GIFTS(TypeDuibaElasticGifts,"弹层活动");

    private Integer type;

    private String name;

    private ActivityTypeEnum(Integer type,String name){
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 获取活动类型枚举类(在WEB端尽量只出现活动枚举类)
     * 主要维护ActivityTypeEnum 和 type的对应关系
     * 这个方法暂时只列出楼层,主会场,子页面等所有会在运营位上出现的活动类型,这些活动都是走活动适配层的
     * 如果后面阁下也认为活动适配层能简化代码,可以换一下心情,来一次轰轰烈烈的重构
     * @return
     */
    public static ActivityTypeEnum getEnumType(Integer type){
        if(hdToolTypeSet.contains(type)){
            return ActivityTypeEnum.ACTIVITY_TOOL;
        }
        if(GAME_TYPES.contains(type)){//不包含积分游戏和小游戏
            return ActivityTypeEnum.GAME;
        }
        switch (type) {
            case TypeDuibaActivity:
                return ActivityTypeEnum.ZHANGTI_ACTIVITY;
            case TypeSecondsKill: // 秒杀专题
                return ActivityTypeEnum.SECONDS_KILL;
            case TypeDuibaSeckill://秒杀活动
                return ActivityTypeEnum.SECONDS_ACTIVITY;
            case TypeDuibaQuestionAnswer: // 兑吧答题活动
                return ActivityTypeEnum.QUESTION_ANSWER;
            case TypeDuibaQuizz://测试题活动
                return ActivityTypeEnum.QUIZZ;
            case TypeDuibaGuess://竞猜
                return ActivityTypeEnum.GUESS;
            case TypeDuibaRob:
                return ActivityTypeEnum.ROB;
            case TypeDuibaCreditGame:
                return ActivityTypeEnum.CREDIT_GAME;
            case TypeDuibaLittleGame:
                return ActivityTypeEnum.LITTLE_GAME;
            case TypePlugin:
                return PLUGIN;
            case TypeDuibaSingleLottery:
                return SINGLE_LOTTERY;
            case TypeAppSingleLottery:
                return APP_SINGLE_LOTTERY;
            case TypeAppManualLottery:
                return MANUAL_LOTTERY;
            case TypeSign:
                return SIGN;
            case TypeDuibaElasticGifts:
                return ELASTIC_GIFTS;
            default:
                throw new ActivityTypeException(type);
        }
    }
}
