package cn.com.duiba.activity.center.api.remoteservice.activity;


import cn.com.duiba.activity.center.api.dto.ActivityGroupIntegrityDto;
import cn.com.duiba.activity.center.api.dto.activity.ActivityGroupDto;
import cn.com.duiba.activity.center.api.dto.activity.ActivityGroupRelationDto;
import cn.com.duiba.activity.center.api.params.PageParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 活动组服务接口
 * Created by xiaoxuda on 2017/2/8.
 */
public interface RemoteActivityGroupService {
    /**
     * 分页查询活动组信息，不包含已删除的活动组
     *
     * @return
     */
    DubboResult<List<ActivityGroupDto>> findActivityGroupByPage(PageParams pageParams);

    /**
     * 插入活动组完整信息
     *
     * @param activityGroupIntegrityDto
     * @return 活动组id
     */
    DubboResult<Long> addActivityGroup(ActivityGroupIntegrityDto activityGroupIntegrityDto);

    /**
     * 根据活动组ID更新活动组完整信息
     *
     * @param activityGroupIntegrityDto
     * @return 更新的活动组数量
     */
    DubboResult<Integer> updateById(ActivityGroupIntegrityDto activityGroupIntegrityDto);

    /**
     * 根据活动组ID查询活动组完整信息
     *
     * @param groupId
     * @return
     */
    DubboResult<ActivityGroupIntegrityDto> findById(Long groupId);

    /**
     * 删除活动组，保留活动组关联的活动
     *
     * @param id
     * @return 删除的活动组数量
     */
    DubboResult<Integer> deleteById(Long id);

    /**
     * 统计所有活动组的数量，不包含已删除的活动组
     *
     * @return
     */
    DubboResult<Integer> countGroup();

    /**
     * 验证给出的活动是否可以添加到对应活动组的活动关系表中,activityGroupRelationDtoList中的数据包含ID时表示更新验证
     * @param groupId
     * @param activityGroupRelationDtoList
     * @return 验证通过返回活动详细信息，验证失败通过DubboResult.msg返回失败原因
     */
    DubboResult<List<ActivityGroupRelationDto>> canInsertOrUpdateToRelation(Long groupId,List<ActivityGroupRelationDto>
            activityGroupRelationDtoList);

    /**
     * 通过唯一键查询活动
     * @param groupId
     * @param activityType
     * @param activityId
     * @return
     */
    DubboResult<ActivityGroupRelationDto> findByGroupIdAndTypeAndActivityId(Long groupId,
                                                                            Integer activityType, Long activityId);
}
