package cn.com.duiba.activity.center.api.remoteservice;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/6/6.
 */
public interface RemoteManualLotteryService {

    /**
     * 
     * scanOverManualLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppManualLotteryDto>> scanOverManualLottery();

    /**
     * 
     * updateManualLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLottery
     * @since JDK 1.6
     */
    void updateManualLottery(AppManualLotteryDto appManualLottery);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLotteryDO
     * @since JDK 1.6
     */
    void insert(AppManualLotteryDto appManualLotteryDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLotteryDO
     * @since JDK 1.6
     */
    void update(AppManualLotteryDto appManualLotteryDO);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<AppManualLotteryDto> find(Long id);

    /* ------------- */

    /**
     * 
     * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 
     * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户在时间段内参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                        Date start, Date end);
    
    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户免费参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户在时间段内免费参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                            Date start, Date end);

    /**
     * 条件搜索开奖记录
     *
     * @param paramMap
     * @return
     */
    DubboResult<List<ManualLotteryOrderDto>> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap);

    /**
     * 条件搜索开奖记录条数
     *
     * @param paramMap
     * @return
     */
    DubboResult<Long> findAllOpenManualLotteryCount(Map<String, Object> paramMap);

    /**
     * 
     * findWardList:(这里用一句话描述这个方法的作用). <br/>
     * 查询中奖清单
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ManualLotteryOrderDto>> findWardList(Long operatingActivityId);

    /**
     * 查询参与清单
     *
     * @param paramMap
     * @return
     */
    DubboResult<List<ManualLotteryOrderDto>> findNoWardList(Map<String, Object> paramMap);

    /**
     * 查询参与清单count
     *
     * @param paramMap
     * @return
     */
    DubboResult<Long> findNoWardListCount(Map<String, Object> paramMap);

    /**
     * 根据ids查询待开奖的用户list
     *
     * @param paramMap
     * @return
     */
    DubboResult<List<ManualLotteryOrderDto>> findStartOpenListByIds(Map<String, Object> paramMap);

    /**
     * 更新中奖用户状态
     *
     * @param id
     * @param activityId
     * @param date
     * @return
     */
    DubboResult<Integer> updateAward(Long id, Long activityId, Date date);

    /**
     * 随机抽一条
     *
     * @param paramMap
     * @return
     */
    DubboResult<ManualLotteryOrderDto> randomFindManualLottery(Map<String, Object> paramMap);

    /**
     * 更新未中奖用户
     *
     * @param paramMap
     */
    void updateNoAwardList(Map<String, Object> paramMap);

    /**
     * 查询未中奖用户
     *
     * @param paramMap
     * @return
     */
    DubboResult<List<ManualLotteryOrderDto>> findAllNoAwardList(Map<String, Object> paramMap);

    /**
     * 查询所有ids
     *
     * @param ids
     * @return
     */
    DubboResult<List<ManualLotteryOrderDto>> findAllByIds(List<Long> ids);

    /**
     * 根据订单号查询
     *
     * @param orderId
     * @return
     */
    DubboResult<ManualLotteryOrderDto> findByOrderId(Long orderId);

    /**
     * 
     * findByAppAndDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    DubboResult<ManualLotteryOrderDto> findByAppAndDeveloperBizId(Long appId, String bizId);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ManualLotteryOrderDto
     * @since JDK 1.6
     */
    void insert(ManualLotteryOrderDto ManualLotteryOrderDto);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @author liyang
     * @param ManualLotteryOrderDto
     * @since JDK 1.6
     */
    void update(ManualLotteryOrderDto ManualLotteryOrderDto);

    /**
     * 
     * findOrder:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<ManualLotteryOrderDto> findOrder(Long id);

}
