package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.creditgame.ConsumeCreditsFailEventDto;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 积分游戏前台接口
 * @author jyc
 * @since 2016-09-05
 */
public interface RemoteCreditGameService {

    /**
     * 根据游戏逻辑ID获取游戏实体(出参将不包含大字段)
     * <br>
     *     Operation 覆盖CreditGame实体
     * @param operationId 积分游戏上架ID
     * @return 积分游戏实体
     */
    DubboResult<CreditGameDto> getCreditGameByOperationId(Long operationId);

    /**
     * 根据游戏逻辑ID获取游戏实体(出参将不包含大字段)
     * @param creditGameId 积分游戏ID
     * @return 积分游戏实体
     */
    DubboResult<CreditGameDto> getCreditGameById(Long creditGameId);
    /**
     * describe : 增加、扣积分后发送通知
     * @author : cdm
     * @date : 2016年9月19日下午4:09:57
     * @param orderNum
     * @return
     */
    DubboResult<String>  crementCreditNotify(String orderNum);
    /**
     * 抽中奖品后处理 (需要迁移到上层)
     * @param creditGameOrderId
     * @param winOption
     * @param options
     * @param ip
     * @return
     */
    DubboResult<Boolean> postWinPrize(Long creditGameOrderId, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options, String ip);

    /**
     * 
     * dispatherConsumerFailedEvent:(这里用一句话描述这个方法的作用). <br/>
     * 发布减积分失败事件(警报)
     * @param consumeCreditsFailEventDto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> dispatherConsumerFailedEvent(ConsumeCreditsFailEventDto consumeCreditsFailEventDto);
}
