package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;

import java.util.List;
import java.util.Map;

/**
 * 兑吧活动工具业务DAO
 */
public interface RemoteDuibaHdtoolServiceNew {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaHdtoolDto> findAutoOff();

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaHdtoolDto find(Long id);

	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	/**
	 * 
	 * findDuibaHdToolsList:(这里用一句话描述这个方法的作用). <br/>
	 * 活动工具分页列表
	 * @param paramMap
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap);

	/**
	 * 
	 * countDuibaHdToolsList:(这里用一句话描述这个方法的作用). <br/>
	 * 统计活动工具条数
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap);

	/**
	 * 
	 * findAllDuibaHdTools:(这里用一句话描述这个方法的作用). <br/>
	 * 根据APP查询活动工具
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<AddActivityDto> findAllDuibaHdTools(Long appId);

	/**
	 * 
	 * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID集合查询活动工具
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaHdtoolDto> findAllByIds(List<Long> ids);

	/**
	 * 
	 * findOptionsByDuibaHdtoolId:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动ID查询奖项
	 * @param hdtoolId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId);

	/**
	 * 
	 * findOptionsByDuibaHdtoolIds:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动ID查询奖项
	 * @param hdtoolIds
	 * @return
	 * @since JDK 1.6
	 */
	public Map<Long, List<DuibaHdtoolOptionsDto>> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds);

	/**
	 * 
	 * countOptionsByHdtoolId:(这里用一句话描述这个方法的作用). <br/>
	 * 查询活动奖项个数
	 * @param hdtoolId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 
	 * findOptionById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaHdtoolOptionsDto findOptionById(Long id);
	
	/**
	 * 
	 * findAllSpecifyByHdToolId:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动ID查询定向
	 * @param hdToolId
	 * @return
	 * @since JDK 1.6
	 */
	public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId);

	/**
	 * 
	 * findSpecifyByHdToolIdAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动ID或APP查询定向关系
	 * @param duibaHdToolId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId);

	/**
	 * 
	 * findSpecifyByHdToolIdsAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动ID或APP查询定向关系
	 * @param duibaHdToolIds
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public Map<Long, HdtoolAppSpecifyDto> findSpecifyByHdToolIdsAndApp(List<Long> duibaHdToolIds, Long appId);

	/**
	 * 
	 * findSpecifyById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询定向关系
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public HdtoolAppSpecifyDto findSpecifyById(Long id);
	
	/**
	 * 
	 * findExtraInfoById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询额外信息
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public ActivityExtraInfoDto findExtraInfoById(Long id);


	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * @param queryMap
	 * @return
	 */
	public Long getCountDuibaHdTool(Map<String, Object> queryMap);

	/**
	 * @param queryMap
	 * @return
	 */
	public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap);

	//from DuibaHdtoolTextChangeDao

	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateAutoOffDateNull(Long id);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 新增兑吧活动工具
	 * @param duibaHdtoolDto
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaHdtoolDto insert(DuibaHdtoolDto duibaHdtoolDto);

	/**
	 * 
	 * deleteById:(这里用一句话描述这个方法的作用). <br/>
	 * 删除兑吧活动
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int deleteById(Long id);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * 修改兑吧活动工具
	 * @param duibaHdtoolDto
	 * @return
	 * @since JDK 1.6
	 */
	public int update(DuibaHdtoolDto duibaHdtoolDto);

	/**
	 * 
	 * updateStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 修改活动工具状态
	 * @param id
	 * @param status
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStatus(Long id, Integer status);

	/**
	 * 
	 * decrementOptionRemaining:(这里用一句话描述这个方法的作用). <br/>
	 * 减奖品数量
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int decrementOptionRemaining(Long id);

	/**
	 * 
	 * incrementOptionRemaining:(这里用一句话描述这个方法的作用). <br/>
	 * 加奖品数量
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int incrementOptionRemaining(Long id);

	/**
	 * 
	 * deleteOptions:(这里用一句话描述这个方法的作用). <br/>
	 * 删除奖项
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 
	 * updateHdtoolPrize:(这里用一句话描述这个方法的作用). <br/>
	 * 修改奖项
	 * @param duibaHdToolOptionDO
	 * @return
	 * @since JDK 1.6
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 
	 * insertHdtoolOption:(这里用一句话描述这个方法的作用). <br/>
	 * 新增兑换活动工具奖项
	 * @param duibaHdToolOptionDO
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaHdtoolOptionsDto insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 
	 * updateHdtoolOption:(这里用一句话描述这个方法的作用). <br/>
	 * 修改兑吧活动工具
	 * @param duibaHdToolOptionDO
	 * @return
	 * @since JDK 1.6
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 
	 * deleteSpecifyById:(这里用一句话描述这个方法的作用). <br/>
	 * 删除定向关系
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int deleteSpecifyById(Long id);

	/**
	 * 
	 * insertSpecify:(这里用一句话描述这个方法的作用). <br/>
	 * 添加定向关系
	 * @param hdtoolAppSpecifyDO
	 * @return
	 * @since JDK 1.6
	 */
	public HdtoolAppSpecifyDto insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO);

	/**
	 * 
	 * updateActivityCategory:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaHdtoolId
	 * @param activityCategoryId
	 * @return
	 * @since JDK 1.6
	 */
	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId);
	
	/**
	 * 
	 * findTag:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询标签
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public String findTag(Long id);
	
	/**
	 * 
	 * findAllSpecifyMap:(这里用一句话描述这个方法的作用). <br/>
	 * 根据map查询定向
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public List<HdtoolAppSpecifyDto> findAllSpecifyMap(Map<String, Object> queryMap);
	
	/**
	 * 
	 * findAllSpecifyByCredordCount:(这里用一句话描述这个方法的作用). <br/>
	 * 统计活动工具条数
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public Integer findAllSpecifyByCredordCount(Map<String, Object> queryMap);
}
