package cn.com.duiba.activity.center.api.dto.hdtool;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧活动工具奖项
 * 
 * @author houwen
 */
public class DuibaHdtoolOptionsDto implements Serializable {
	private static final long serialVersionUID = 6439406312611485910L;

	private Long id;
	private Long duibaHdtoolId;
	private String name;
	private Integer payload;
	private Long appItemId;
	private Long itemId;
	private String prizeType;
	private String facePrice;
	private String logo;
	private Integer remaining;
	private String rate;
	private Boolean hidden;
	private String description;
	private Integer limitCount;
	private Integer minComein;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;
	
	private Boolean valid;//不是数据库字段
	private Boolean addrlimit;//不是数据库字段
	private String itemName;//不是数据库字段

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolOptionsDto.
	 *
	 */
	public DuibaHdtoolOptionsDto() {
		super();
	}

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolOptionsDto.
	 *
	 * @param id
	 */
	public DuibaHdtoolOptionsDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolOptionsDto.
	 *
	 * @param init4insert
	 */
	public DuibaHdtoolOptionsDto(boolean init4insert) {
		if (init4insert) {
			hidden = false;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	public Boolean getValid() {
		return valid;
	}

	public void setValid(Boolean valid) {
		this.valid = valid;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getDuibaHdtoolId() {
		return duibaHdtoolId;
	}

	public void setDuibaHdtoolId(Long duibaHdtoolId) {
		this.duibaHdtoolId = duibaHdtoolId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public String getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(String facePrice) {
		this.facePrice = facePrice;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public String getRate() {
		return rate;
	}

	public void setRate(String rate) {
		this.rate = rate;
	}

	public Boolean getHidden() {
		return hidden;
	}

	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getMinComein() {
		return minComein;
	}

	public void setMinComein(Integer minComein) {
		this.minComein = minComein;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Boolean getAddrlimit() {
		return addrlimit;
	}

	public void setAddrlimit(Boolean addrlimit) {
		this.addrlimit = addrlimit;
	}

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

}
