package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.service.exception.BusinessException;

/**
 * 活动工具消费库存消费
 * @author zp
 * from HdtoolConsumeStockService
 *
 */
public interface RemoteHdtoolStockConsumeService {

	/**
	 * 兑吧活动工具扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeDuibaHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 兑吧活动工具返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackDuibaHdtoolOptionStock(String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 开发者活动工具扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeAppHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 开发者活动工具返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackAppHdtoolOptionStock(String bizId, String bizSource) throws BusinessException;
	
}
