package cn.com.duiba.activity.center.api.dto.sign;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.SignTypeEnum;

/**
 * 用户签到信息
 * Created by xiaoxuda on 2017/6/5.
 */
public class SignInfoDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = -3868872593660301324L;

    /**
     * 今日签到状态
     */
    private Boolean todaySigned = false;

    /**
     * 签到类型
     */
    private SignTypeEnum signType;

    /**
     * 连续签到天数
     */
    private Integer continueDay;

    /**
     * 今日签到可得积分
     */
    private Integer credits;

    /**
     * 明日签到可得积分
     */
    private Integer creditsTomorrow;

    /**
     * 今日签到可得抽奖次数
     */
    private Integer activityCount;

    /**
     * 明日签到可得抽奖次数
     */
    private Integer activityCountTomorrow;

    /**
     * 用户第一次签到的时间
     */
    private Date firstSignDate;

    public Boolean getTodaySigned() {
        return todaySigned;
    }

    public void setTodaySigned(Boolean todaySigned) {
        this.todaySigned = todaySigned;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getCreditsTomorrow() {
        return creditsTomorrow;
    }

    public void setCreditsTomorrow(Integer creditsTomorrow) {
        this.creditsTomorrow = creditsTomorrow;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public Integer getActivityCountTomorrow() {
        return activityCountTomorrow;
    }

    public void setActivityCountTomorrow(Integer activityCountTomorrow) {
        this.activityCountTomorrow = activityCountTomorrow;
    }

    public Date getFirstSignDate() {
        return firstSignDate;
    }

    public void setFirstSignDate(Date firstSignDate) {
        this.firstSignDate = firstSignDate;
    }
}
