package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterRuntimeException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 8/1/17.
 */
public enum SignActionEnum {
    WAIT(0, "等待处理"),
    FAILED(1, "失败"),
    SUCCESS(2, "成功");

    private static Map<Integer, SignActionEnum> typeEnumMap = new HashMap<>();

    static {
        for (SignActionEnum typeEnum : SignActionEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static SignActionEnum getByCode(int code) {
        SignActionEnum type = typeEnumMap.get(code);
        if(type == null){
            throw new ActivityCenterRuntimeException("不支持的状态");
        }
        return type;
    }

    private Integer code;
    private String desc;

    SignActionEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
