/**
 * Project Name:activity-center-api File Name:RemoteActivityCategoryBackendService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice Date:2016年6月7日上午8:52:18 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.other.ActivityCategorySpecifyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityCategoryBackendService <br/>
 * Function: 活动类目管理的后台接口 <br/>
 * Date: 2016年6月7日 上午8:52:18 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteActivityCategoryBackendService {

    /**
     * 创建一个活动分类
     *
     * @author xuhengfei
     * @param name
     * @param content
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> createCategory(String name, String content);

    /**
     * 修改活动分类的皮肤
     *
     * @author xuhengfei
     * @param id
     * @param name
     * @param content
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> editCategoryContent(long id, String name, String content);

    /**
     * 启用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> enableCategory(long id);

    /**
     * 禁用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> disableCategory(long id);

    /**
     * 查询所有的活动分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityCategoryDto>> findAll();
    
    /**
     * 根据id集合查询 
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param ids
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityCategoryDto>> findByIds(List<Long> ids);
    
    /**
     * 删除活动分类
     *
     * @author zhanglihui
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> deleteCategory(long id);

    /**
     * 查询默认的分类。 产品需求：开发者自有的活动，全部自动归属默认分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    DubboResult<ActivityCategoryDto> findDefaultCategory();

    /**
     * findAllActivitiesByAppCategory:查询App下某个分类的所有活动列表. <br/>
     * 开发者子页面展示活动用，要求此活动兑吧与开发者均处于开启状态.<br/>
     * 当operating_activity表中的状态被置为关闭时，删除关系表数据，当置为开启时，新增关系表数据.<br/>
     * 开启需要考虑的点：计划任务推送，人为点击开启 关闭需要考虑的点：管理员关闭活动，人为点击关闭
     * 
     * @author wubo
     * @param appId 应用id
     * @param categoryId 活动类目id
     * @return CategoryActivityDto
     * @since JDK 1.6
     */
    DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId);

    /**
     * sortActivitiesByAppCategory:重新设置活动列表的权重排序. <br/>
     * 开发者活动子页面分类用.<br/>
     * 当前子页面某个活动顺序变更时，重新分配当前子页面的所有活动权重值，并全部更新.<br/>
     *
     * @author wubo
     * @param appId
     * @param categoryId
     * @param activities
     * @return Boolean
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortActivitiesByAppCategory(long appId, long categoryId, List<CategoryActivityDto> activities);

    /**
     * saveActivityCategoryRelation:新增活动类目关系. <br/>
     *
     * @author wubo
     * @param CategoryActivityDto(必填参数):Long appId,Long categoryId,Long operatingActivityId,Integer payload
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> saveActivityCategoryRelation(CategoryActivityDto dto);

    /**
     * removeActivityCategoryRelation:删除活动类目关系. <br/>
     *
     * @author wubo
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivityCategoryRelation(Long operatingActivityId);

    /**
     * findActivityCategoryRelation:根据 operatingActivityId 查询活动类目关系. <br/>
     * 
     * @author wubo
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<CategoryActivityDto> findActivityCategoryRelation(Long operatingActivityId);
    
    /**
	 * 活动子页面-查询活动定向开发者列表
	 * @author zhengjy
	 * @param activityCategoryId 
	 * @param pageIndex 
	 * @param pageSize 
	 * @return 
	 */
	public DubboResult<List<ActivityCategorySpecifyDto>> findSpecifyAll(Long activityCategoryId,Integer pageIndex,Integer pageSize);
	/**
	 * 活动子页面-查询活动定向开发者count
	 * @author zhengjy
	 * @param activityCategoryId 
	 * @param pageIndex 
	 * @param pageSize
	 * @return
	 */
	public DubboResult<Integer> findSpecifyAllCount(Long activityCategoryId,Integer pageIndex,Integer pageSize);
	
	/**
	 * 活动子页面-保存开发者定向
	 * @author zhengjy
	 * @param activityCategorySpecifyDto
	 * @return
	 */
	public DubboResult<Boolean> specifySave(ActivityCategorySpecifyDto activityCategorySpecifyDto);
	
	/**
	 * 活动子页面-删除开发者定向
	 * @author zhengjy
	 * @param id
	 * @return
	 */
	public DubboResult<Boolean> specifyDelete(Long id);
	
	/**
	 * 活动子页面-查询app下定向活动列表
	 * @author zhengjy
	 * @param appId 
	 * @return 
	 */
	DubboResult<List<ActivityCategorySpecifyDto>> findByAppSpecifys(long appId);
    /**
     * 批量更新活动类目 使用场景：兑吧活动修改归类时，相应的开发者活动需要更新到对应的子页面类目下
     *
     * @author zhanglihui
     * @param categoryId 类目id
     * @param operatingActivityList 开发者活动列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateActivityCategoryRelation(Long categoryId, List<OperatingActivityDto> operatingActivityList);
    
    /**
     * 
     * 根据appId查询开发者后台显示的子页面列表
     * 1. 子页面必须开启
     * 2. 子页面若开启定向，appId必须在定向列表内
     *
     * @author zhanglihui
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityCategoryDto>> findCategoryByAppId(Long appId);
}
