/**
 * Project Name:activity-center-api File Name:RemoteLittleGameBackendService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.littlegame Date:2016年9月29日下午2:59:53 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.api.remoteservice.littlegame;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.littlegame.LittleGameDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteLittleGameBackendService <br/>
 * Date: 2016年9月29日 下午2:59:53 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteLittleGameBackendService {

    /**
     * queryLittleGameById:根据id查询. <br/>
     * @author wubo
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<LittleGameDto> queryLittleGameById(Long id);
    /**
     * queryLittleGameByPage:(这里用一句话描述这个方法的作用). <br/>
     * @author wubo
     * @param title 可根据title筛选，不填不筛选
     * @param offset 不填查所有
     * @param max
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<LittleGameDto>> queryLittleGameByPage(String title, Integer offset, Integer max);
    
    /**
     * queryLittleGameCount:统计. <br/>
     *
     * @author wubo
     * @param title 可根据title筛选，不填不筛选
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> queryLittleGameCount(String title);
    
    /**
     * saveOrUpdateLittleGame:保存接口，有id编辑，无id新增. <br/>
     * 编辑时传null的参数不编辑
     * @author wubo
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> saveOrUpdateLittleGame(LittleGameDto dto);
    
    /**
     * 
     * removeLittleGame:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeLittleGame(Long id);
    /**
     * updateCategoryId:更新类目id. <br/>
     * 传啥存啥，传null存null
     * @author wubo
     * @param id
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateCategoryId(Long id,Long categoryId);
}
