package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.SignTypeEnum;

import java.io.Serializable;
import java.util.List;

/**
 * Created by xiaoxuda on 2017/6/1.
 */
public class SignRuleConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = 948952194538419135L;

    /**
     * 签到规则在json配置中的key
     */
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE_ITEM = "items";
    public static final String KEY_RULE_ADD = "incr";

    /**
     * 签到类型
     */
    private SignTypeEnum type;
    /**
     * 连续逐天递增量
     */
    private Integer incr = 0;
    /**
     * 规则条目（有序）
     */
    private List<SignRuleItemDto> items;

    public SignTypeEnum getType() {
        return type;
    }

    public void setType(SignTypeEnum type) {
        this.type = type;
    }

    public Integer getIncr() {
        return incr;
    }

    public void setIncr(Integer incr) {
        this.incr = incr;
    }

    public List<SignRuleItemDto> getItems() {
        return items;
    }

    public void setItems(List<SignRuleItemDto> items) {
        this.items = items;
    }
}
