package cn.com.duiba.activity.center.api.dto.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.ReSignRuleConfigDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRuleConfigDto;
import cn.com.duiba.activity.center.api.enums.SignActivityStatusEnum;
import cn.com.duiba.activity.center.api.enums.SignActivityTypeEnum;
import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public class SignActivityDto implements Serializable{
    private static final long serialVersionUID = 1752779918200677322L;

    public static final Integer AppDirectSwitch = 1;
    public static final Integer DeveloperBlackSwitch = 2;

    //extra内容KEY
    public static final String KEY_SIGNRULE = "signRule";
    //日历之前的日期
    public static final String KEY_BEFOREDATE="beforeDate";
    public static final String KEY_AFTERDATE="afterDate";
    //是否开启补签
    public static final String KEY_RE_SIGN_OPEN = "openReSign";
    //补签规则
    public static final String KEY_RE_SIGN_RULE="reSignRule";

    private Long id;
    /**
     * 签到活动标题
     */
    private String title;

    /**
     * 签到活动类型
     */
    private SignActivityTypeEnum signType;

    /**
     * 描述
     */
    private String description;

    /**
     * 活动状态
     */
    private SignActivityStatusEnum status;
    /**
     * 功能开关，位运算保存
     */
    private Integer switches;
    /**
     * 预览图
     */
    private String previewImage;
    /**
     * 删除状态
     */
    private Boolean deleted;

    /**
     * 额外字段
     */
    private JSONObject extra;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SignActivityTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignActivityTypeEnum signType) {
        this.signType = signType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SignActivityStatusEnum getStatus() {
        return status;
    }

    public void setStatus(SignActivityStatusEnum status) {
        this.status = status;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public String getPreviewImage() {
        return previewImage;
    }

    public void setPreviewImage(String previewImage) {
        this.previewImage = previewImage;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public void putToExtra(String key, Object val){
        if(extra == null){
            extra = new JSONObject();
        }
        extra.put(key,val);
    }

    public Object getFromExtra(String key){
        if(extra == null){
            return null;
        }
        return extra.get(key);
    }

    /**
     * 提取签到规则信息
     * @return
     */
    public SignRuleConfigDto getSignRuleConfig(){
        if(extra == null){
            return null;
        }
        return extra.getObject(KEY_SIGNRULE, SignRuleConfigDto.class);
    }

    public ReSignRuleConfigDto getReSignRuleConfig(){
        if(extra == null){
            return null;
        }
        return extra.getObject(KEY_RE_SIGN_RULE, ReSignRuleConfigDto.class);
    }

    public boolean isOpenReSign(){
        if(extra == null){
            return false;
        }
        return Boolean.TRUE.equals(extra.getBoolean(KEY_RE_SIGN_OPEN));
    }

    public Long getDateArea(String key){
        if(extra == null){
            return 14L;
        }
        if(!key.equals(KEY_BEFOREDATE)&&!key.equals(KEY_AFTERDATE)){
            throw new ActivityCenterException("查询之前、之后的key值不正确");
        }
        return extra.getObject(key, Long.class);
    }

}
