package cn.com.duiba.activity.center.api.remoteservice.anticheat;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 从duiba-service迁移过来
 */
public interface RemoteExchangeLimitService {

    /**
     * selectExchangeLimit:直充类奖品防刷验证.
     *
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id								not null
     * @param type                奖品类型									not null
     * @param account             领奖账号									not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    DubboResult<Long> checkExchangeLimit(Long appId, Long operatingActivityId, String type, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷验证记录创建.
     *
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id								not null
     * @param consumerId          用户id									not null
     * @param type                奖品类型									not null
     * @param account             领奖账号									not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void createExchangeLimitRecord(Long appId, Long operatingActivityId, Long consumerId, String type, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷  用户与账户 绑定关系解除.
     *
     * @param type                奖品类型									not null
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id									not null
     * @param account             领奖账号										not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void dataBackExchangeLimit(Long appId, String type, Long operatingActivityId, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷验证.
     *
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                               not null
     * @param type                奖品类型                                   not null
     * @param account             领奖账号                                 not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    DubboResult<Long> checkExchangeLimitType(Long appId, Long operatingActivityId, String type, String account, String activityType);

    /**
     * selectExchangeLimit:直充类奖品防刷验证记录创建.
     *
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                               not null
     * @param consumerId          用户id                                    not null
     * @param type                奖品类型                                   not null
     * @param account             领奖账号                                 not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void createExchangeLimitRecordType(Long appId, Long operatingActivityId, Long consumerId, String type, String account, String activityType);

    /**
     * selectExchangeLimit:直充类奖品防刷  用户与账户 绑定关系解除.
     *
     * @param type                奖品类型                                   not null
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                                   not null
     * @param account             领奖账号                                     not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void dataBackExchangeLimitType(Long appId, String type, Long operatingActivityId, String account, String activityType);

}
