package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameConsumerRecordDto;
import cn.com.duiba.activity.center.api.dto.ngame.SimpleConsumerRankDto;

import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: RemoteNgameConsumerRecordService <br/>
 * date: 2016年12月1日 下午3:58:37 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteNgameConsumerRecordService {

    /**
     * 
     * findRecordByConIdAndNgameId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param duibaNgameId
     * @return
     * @since JDK 1.6
     */
	public NgameConsumerRecordDto findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId);

	/**
	 * 
	 * findGameConfigDuibaScoreByDesc:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameId
	 * @param number
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	/**
	 * 
	 * findGameConfigDuibaScoreByAsc:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameId
	 * @param number
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);
	
	/**
	 * 
	 * findConsumerGameConfigDuibaScoreByDesc:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaNgameId
	 * @param number
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	/**
	 * 
	 * findConsumerGameConfigDuibaScoreByAsc:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameId
	 * @param number
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param gameConsumerRecordDO
	 * @return
	 * @since JDK 1.6
	 */
	public NgameConsumerRecordDto insert(NgameConsumerRecordDto gameConsumerRecordDO);

	/**
	 * 
	 * updateScore:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param score
	 * @param autoOpenPrizeId
	 * @param gameOrderId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId);

	/**
	 * 不清楚此方法的原有逻辑，如果需要更新总分或者最高分，建议使用updateMaxScoreAndTotal
	 * @param id
	 * @param score
	 * @param shareScore
	 * @param autoOpenPrizeId
	 * @param gameOrderId
	 * @return
	 */
	public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId);

	/**
	 * 
	 * updateTotalScore:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param shareScore
	 * @return
	 * @since JDK 1.6
	 */
	public Integer updateTotalScore(Long id, Integer shareScore);

	/**
	 * 
	 * updateIsGivePrize:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param isGivePrize
	 * @return
	 * @since JDK 1.6
	 */
	public Integer updateIsGivePrize(Long id, Boolean isGivePrize);

	/**
	 * 
	 * updateAutoOpenPrizeId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param autoOpenPrizeId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId);

	/**
	 * 
	 * markCheat:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param cheat
	 * @since JDK 1.6
	 */
	public void markCheat(Long id, Boolean cheat);
	
	/**
	 * 
	 * findByConsumerAndIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findByConsumerAndIds(Long consumerId, List<Long> ids);

	/**
	 * 该方法迁移至 findTopWinningByMaxScore/findTopWinningByTotalScore通过最高分/总分排序查询
	 * @param params
	 * @return
	 */
	List<NgameConsumerRecordDto> findTopWinning(Map<String, Object> params);

	/**
	 * 该方法迁移至 findTopWinningByMaxScore/findTopWinningByTotalScore通过最高分/总分排序查询
	 * @param params
	 * @return
	 */
	List<NgameConsumerRecordDto> findTopWinningAsc(Map<String, Object> params);

	/**
	 * 
	 * countCheatBefore:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param limit
	 * @param gameConfigDuibaId
	 * @return
	 * @since JDK 1.6
	 */
	Integer countCheatBefore(Integer limit, Long gameConfigDuibaId);

	/**
	 * 
	 * countTopWinning:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param params
	 * @return
	 * @since JDK 1.6
	 */
	Integer countTopWinning(Map<String, Object> params);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	NgameConsumerRecordDto find(Long id);

	/**
	 * 
	 * setCheatReason:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param cheatReason
	 * @since JDK 1.6
	 */
	void setCheatReason(Long id, String cheatReason);

	/**
	 * 
	 * findShareConsumerByGameConfigDuibaId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameId
	 * @return
	 * @since JDK 1.6
	 */
	public List<NgameConsumerRecordDto> findShareConsumerByGameConfigDuibaId(Long duibaNgameId);
	/**
	 * 
	 * updateByGameConfigShare:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param duibaNgameId
	 * @param shareScore
	 * @return
	 * @since JDK 1.6
	 */
	public int updateByGameConfigShare(Long id, Long duibaNgameId, Long shareScore);
	/**
	 * 
	 * findByConsumerIdAndGameConfigDuibaId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param consumerId
	 * @param gameConfigDuibaId
	 * @return
	 * @since JDK 1.6
	 */
	NgameConsumerRecordDto findByConsumerIdAndGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);
	/**
	 * 
	 * updateScore:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param score
	 * @since JDK 1.6
	 */
	void updateScore(Long id, Long score);

	/**
	 * 更新游戏分数，并且更新redis中的排名数据
     */
	void updateRedisRank(Long id, String cid, Long score, Boolean isDesc);

	/**
	 * 查询用户分数排名
     */
	Long findScoreRank(Long gameId, String cid, Boolean isDesc);

	/**
	 * 获取用户排名,最多返回两百条纪录
	 */
	List<SimpleConsumerRankDto> getConsumerRank(Long gameId, Boolean isDesc);

	/**
	 * 更新用户记录的最高分和总分
     */
	void updateMaxScoreAndTotal(NgameConsumerRecordDto record);

	/**
	 *	查询游戏记录表按最高分排序
	 * @param params sort:max_score字段排序方式（DESC/ASC）,  gameDuibaId:游戏id, consumerId:用户id,  cheat:是否作弊
	 * @return
	 */
	List<NgameConsumerRecordDto> findTopWinningByMaxScore(Map<String, Object> params);

	/**
	 *	查询游戏记录表按总分排序
	 * @param params  gameDuibaId:游戏id, consumerId:用户id,  cheat:是否作弊
	 * @return
	 */
	List<NgameConsumerRecordDto> findTopWinningByTotalScore(Map<String, Object> params);


}
