package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 补签奖励方式
 * Created by xiaoxuda on 2017/8/14.
 */
public enum ReSignAwardTypeEnum {
    NO(1, "无奖励"),
    CONTINUE(2, "计算补签后，补签所在区域形成的连续签到天数计算奖励规则");

    private static Map<Integer, ReSignAwardTypeEnum> valueMap = new HashMap<>();
    static{
        for(ReSignAwardTypeEnum typeEnum : values()){
            valueMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code查询补签类型
     * @param code
     * @return
     */
    public static ReSignAwardTypeEnum getByCode(Integer code){
        ReSignAwardTypeEnum type = valueMap.get(code);
        if(type == null){
            throw new ActivityCenterException("不支持的补签奖励类型");
        }
        return type;
    }

    private Integer code;
    private String desc;

    ReSignAwardTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
