package cn.com.duiba.activity.center.api.remoteservice.activity;

import java.util.List;

import org.javatuples.Pair;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOptionsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteHdtoolOperatingService.java <br/>
 * @author  gey 
 * @date 创建时间：2017年7月26日 下午4:45:34 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface RemoteHdtoolOperatingService {

	/**
	 * 
	 * hdtoolIndexByOpIdValid:根据opId查询活动信息. <br/>
	 * 
	 * 该接口  需要对 活动进行 黑名单和定向校验	 （减少活动web 调用 活动中次数）
	 * 
	 * @param opId
	 * @param appId
	 * @param developerId
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexByOpIdValid(Long opId,Long appId,Long developerId);
	
	/**
	 * 
	 * hdtoolIndexByDuibaIdValid:根据duibaId查询活动信息. <br/>
	 * 
	 * 该接口  需要对 活动进行 黑名单和定向校验	 （减少活动web 调用 活动中次数）
	 * 
	 * @param opId
	 * @param appId
	 * @param developerId
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexByDuibaIdValid(Long duibaId,Long appId,Long developerId);
	
	/**
	 * 
	 * hdtoolElementDuibaIdValid:根据opId,duibaId 查询活动信息 <br/>
	 * 
	 * @param opId
	 * @param duibaId
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolElementDuibaIdValid(Long opId, Long duibaId);
	
	/**
	 * 
	 * findHdtoolOptions:根据opId,duibaId 查询活动配置的奖品信息 <br/>
	 * 
	 * @param opId
	 * @param duibaId
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<HdtoolOptionsDto>> findHdtoolOptions(Long opId, Long duibaId);

}
