package cn.com.duiba.activity.center.api.remoteservice.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarAppRelationDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 功能描述:分类栏与应用关联表操作接口定义
 * (也称分类栏定向实体)
 *
 * @author sunchangji
 * @date 2016/10/19
 */
public interface RemoteRobCategoryBarAppRelationService {

    /**
     * 查询全部定向表列表数据，并对数据进行按分类栏id分组
     *
     * @return
     */
    DubboResult<List<RobCategoryBarAppRelationDto>> getRobCategoryBarAppList();

    /**
     * 根据分类栏id删除分类栏定向
     *
     * @param barId 分类栏id
     * @return
     */
    DubboResult<Boolean> deleteById(Long barId);

    /**
     * 根据分类栏id批量删除分类栏定向
     *
     * @param barIds 分类栏id集合
     * @return
     */
    DubboResult<Boolean> batchDeleteById(List<Long> barIds);

    /**
     * 批量新增分类栏定向
     * 1.先根据appId检查是否已经存在定向，存在则新增失败
     * 2.批量保存
     *
     * @param batchList 新增数据集合
     * @return
     */
    DubboResult<Boolean> batchInsertBarAppRelation(List<RobCategoryBarAppRelationDto> batchList);

    /**
     * 批量更新
     *
     * @param batchList
     * @return
     */
    DubboResult<Boolean> batchUpdateBarAppRelation(List<RobCategoryBarAppRelationDto> batchList);

    /**
     * 批量删除分类栏对应下的app
     *
     * @param appIds 应用id集合
     * @return
     */
    DubboResult<Boolean> batchDeleteBarAppRelation(List<Long> appIds);
}
