package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.ActivityTimeValidityTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignTypeEnum;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;

/**
 * Created by xiaoxuda on 2017/6/1.
 */
public class SignRuleConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = 948952194538419135L;

    /**
     * 签到规则在json配置中的key
     */
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE_ITEM = "items";
    public static final String KEY_RULE_ADD = "incr";
    public static final String KEY_VALIDITY_TYPE = "acValidityType";

    /**
     * 签到类型
     */
    private SignTypeEnum type;
    /**
     * 连续逐天递增量
     */
    private Integer incr = 0;
    /**
     * 规则条目（有序）
     */
    private List<SignRuleItemDto> items;

    /**
     * 抽奖次数有效期类型
     */
    private ActivityTimeValidityTypeEnum acValidityType;

    /**
     * 获取周期内天数
     * @return
     */
    public Integer getCircleDay(){
        int signCircleDay = items.size();
        if(SignTypeEnum.MONTH.equals(type)){
            signCircleDay = Calendar.getInstance().getActualMaximum(Calendar.DATE);
        }
        return signCircleDay;
    }

    public SignTypeEnum getType() {
        return type;
    }

    public void setType(SignTypeEnum type) {
        this.type = type;
    }

    public Integer getIncr() {
        return incr;
    }

    public void setIncr(Integer incr) {
        this.incr = incr;
    }

    public List<SignRuleItemDto> getItems() {
        return items;
    }

    public void setItems(List<SignRuleItemDto> items) {
        this.items = items;
    }

    public ActivityTimeValidityTypeEnum getAcValidityType() {
        return acValidityType;
    }

    public void setAcValidityType(ActivityTimeValidityTypeEnum acValidityType) {
        this.acValidityType = acValidityType;
    }
}
