package cn.com.duiba.activity.center.api.remoteservice.flow;

import cn.com.duiba.activity.center.api.dto.flow.ActivityFlowRuleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * Created by zzy on 2017/4/19.
 */
public interface RemoteActivityFlowRuleBackendService {
    /**
     * 修改流量配置
     * appId, ruleType, activityType必填
     * validRegions和validPeriod没有修改时传递旧值
     *
     * @param activityFlowRuleDto
     * @return
     */
    DubboResult<Boolean> update(ActivityFlowRuleDto activityFlowRuleDto);

    /**
     * 批量更新
     *
     * @param activityFlowRuleDtos
     * @return
     */
    DubboResult<List<Boolean>> updateList(List<ActivityFlowRuleDto> activityFlowRuleDtos);

    /**
     * 新增流量配置
     *
     * @param activityFlowRuleDto
     * @return
     */
    DubboResult<Long> insert(ActivityFlowRuleDto activityFlowRuleDto);

    /**
     * 根据唯一索引查询配置
     *
     * @param appId
     * @param ruleType
     * @param activityType
     * @return
     */
    DubboResult<ActivityFlowRuleDto> findByKey(Long appId, Integer ruleType, Integer activityType);

    /**
     * 根据唯一索引查询配置
     *
     * @param appIds
     * @param ruleType
     * @param activityType
     * @return
     */
    DubboResult<Map<Long, ActivityFlowRuleDto>> findListByKey(Set<Long> appIds, Integer ruleType, Integer activityType);
}
