/**
 * Project Name:activity-center-api
 * File Name:RemoteTodayRobSeckillService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.rob
 * Date:2016年10月9日下午1:48:08
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.rob;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 今日必抢秒杀免单服务接口
 * Date:     2016年10月9日 下午1:48:08 <br/>
 * @author   zhanglihui
 * @version  
 * @see 	 
 */
public interface RemoteTodayRobSeckillService {

    /**
     * 手机端查询秒杀区间
     *
     * @author zhanglihui
     * @param appId 应用id
     * @param showEntrance 秒杀区间展示入口 {@link SeckillShowEntranceEnum}
     * @return
     */
    DubboResult<List<TodayRobSeckillAppDto>> findSeckillListByApp(Long appId, String showEntrance);
    
    /**
     * @deprecated findSeckillListByApp
     * findSeckillListByApp:(这里用一句话描述这个方法的作用). <br/>
     * @param appId
     * @return
     * @since JDK 1.6
     */
    @Deprecated
    DubboResult<List<TodayRobSeckillAppDto>> findSeckillListByApp(Long appId);
}

