package cn.com.duiba.activity.center.api.remoteservice.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.service.exception.BusinessException;

/**
 * 
 * ClassName: RemoteActStockConsumerService <br/>
 * date: 2016年12月1日 下午6:28:09 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteActStockConsumerService {

	//from ActStockConsumerService in credits
	
    /**
     * 
     * consumeActStock:(这里用一句话描述这个方法的作用). <br/>
     * 消费活动预分配库存
     * @param prizeId
     * @param bizId
     * @param bizSource
     * @param appId
     * @throws BusinessException
     * @since JDK 1.6
     */
	public void consumeActStock(Long prizeId, String bizId, String bizSource, Long appId) throws BusinessException;
	 
	/**
	 * 
	 * paybackActStock:(这里用一句话描述这个方法的作用). <br/>
	 * 还活动预分配库存
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void paybackActStock(String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * findActValidStock:(这里用一句话描述这个方法的作用). <br/>
	 * 查询活动可用的预分配库存
	 * @param relationPrizeId
	 * @param relationType
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public ActPreStockDto findActValidStock(Long relationPrizeId, String relationType, Long appId);
	
}
