package cn.com.duiba.activity.center.api.enums;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/** 
 * ClassName:ActivityThroughPrizeTypeEnum.java <br/>
 * @author  gey 
 * @date 创建时间：2017年9月14日 下午5:22:26 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public enum ActivityThroughPrizeTypeEnum {
	
	PLUGIN(1,"插件式抽奖工具"),
	BACK(2,"后退"),
	FORWARD(3,"前进"),
	END(4,"终点"),
	PRIZE(5,"活动工具奖品");
	/** 描述 */
	private String desc;
	/** code */
	private Integer code;
	private static Map<Integer,ActivityThroughPrizeTypeEnum> typeMap = Maps.newHashMap();
	private static List<ActivityThroughPrizeTypeEnum> list =Lists.newArrayList();

	private ActivityThroughPrizeTypeEnum(Integer code,String desc) {
		this.desc = desc;
		this.code = code;
	}

	/**
	 * 获取描述
	 * @return
	 */
	public String getDesc() {
		return desc;
	}

	/**
	 * 获取描述
	 * @return
	 */
	public Integer getCode() {
		return code;
	}
	
	static{
		for(ActivityThroughPrizeTypeEnum typeClass : ActivityThroughPrizeTypeEnum.values()){
			typeMap.put(typeClass.getCode(),typeClass);
			list.add(typeClass);
		}
	}

	/**
	 * 根据type获取具体枚举类型
	 * @param type
	 * @return
	 */
	public static ActivityThroughPrizeTypeEnum getByType(Integer key){
		return typeMap.get(key);
	}
	
	/**
	 * 获取全部 枚举值和名称
	 * @param type
	 * @return
	 */
	public static List<ActivityThroughPrizeTypeEnum> getAll(){
		return list;
	}
}