package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.activity.CLCardConfigDto;
import cn.com.duiba.activity.center.api.params.CLCardPageQueryParam;
import cn.com.duiba.activity.center.api.params.GrantCLCardDecideParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 集卡中大奖服务
 * Created by xiaoxuda on 2017/10/25.
 */
public interface RemoteCLCardService {
    /**
     * 保存集卡配置
     * @param dto
     * @return
     */
    DubboResult<Long> insert(CLCardConfigDto dto);

    /**
     * 通过配置ID查询配置项详细信息
     * @param id
     * @return
     */
    DubboResult<CLCardConfigDto> findById(Long id);

    /**
     * 分页查询
     * @param param
     * @return
     */
    DubboResult<List<CLCardConfigDto>> findByPage(CLCardPageQueryParam param);

    /**
     * 通过ID更新数据
     * @param dto
     * @return dto.getId()不可为NULL
     */
    DubboResult<Boolean> updateById(CLCardConfigDto dto);

    /**
     * 删除ID对应配置
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteById(Long id);

    /**
     * 发卡决断
     * @return true:可发卡,false:不可发卡
     */
    DubboResult<Boolean> grantCLCardDecide(GrantCLCardDecideParam param);
}
