package cn.com.duiba.activity.center.api.remoteservice.activity_order;

import cn.com.duiba.activity.center.api.dto.activity_order.ActivityOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 活动订单接口
 * @author houwen
 */
public interface RemoteActivityOrderService {
	
    /**
     * 创建活动订单
     * @param orderDto
     * @return
     */
    public DubboResult<String> createOrder(ActivityOrderDto orderDto);
     
    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
	public DubboResult<ActivityOrderDto> findByOrderNum(String orderNum);
	
	/**
     * 订单扣积分成功
     * @param orderNum
     * @param activityOptionId
     * @param activityOptionName
     * @param activityOptionType
     * @param activityOptionFacePrice
     * @param appItemId
     * @param itemId
     * @param gid
     * @param gtype
     * @param couponId
     * @return
     */
    public DubboResult<Boolean> consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
    
    /**
     * 订单扣积分成功--降级
     * @param orderNum
     * @param activityOptionId
     * @param activityOptionName
     * @param activityOptionType
     * @param activityOptionFacePrice
     * @param appItemId
     * @param itemId
     * @param gid
     * @param gtype
     * @param couponId
     * @return
     */
    public DubboResult<Boolean> consumeCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
    
    
    /**
     * 订单扣积分失败
     * @param orderNum
     * @param activityOptionId
     * @param activityOptionName
     * @param activityOptionType
     * @param activityOptionFacePrice
     * @param appItemId
     * @param itemId
     * @param gid
     * @param gtype
     * @param couponId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    public DubboResult<Boolean> consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
    
    /**
     * 订单加积分成功
     * @param orderNum
     * @param activityOptionId
     * @param activityOptionName
     * @param activityOptionType
     * @param activityOptionFacePrice
     * @param appItemId
     * @param itemId
     * @param gid
     * @param gtype
     * @param couponId
     * @return
     */
    public DubboResult<Boolean> addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
     
    /**
     * 订单加积分失败
     * @param orderNum
     * @param activityOptionId
     * @param activityOptionName
     * @param activityOptionType
     * @param activityOptionFacePrice
     * @param appItemId
     * @param itemId
     * @param gid
     * @param gtype
     * @param couponId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    public DubboResult<Boolean> addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
     
    /**
     * 订单加积分处理中状态更新
     * @param orderNum
     * @return
     */
    public DubboResult<Boolean> addCreditsStatusToProcessing(String orderNum);
    /**
     * 订单置为待领奖状态
     * @param orderNum
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToWait(String orderNum);
     
    /**
     * 订单置为领奖成功
     * @param orderNum
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToSuccess(String orderNum);
     
    /**
     * 订单置为领奖失败
     * @param orderNum
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToFail(String orderNum);
     
    /**
     * 订单置为未领奖过期
     * @param orderNum
     * @return
     */
    public DubboResult<Boolean> exchangeStatusToOverdue(String orderNum);

    /**
     * 订单批量置为未领奖过期
     * @param orderNums
     * @return
     */
    public DubboResult<List<String>> exchangeStatusToOverdueBatch(List<String> orderNums);


    /**
     * 根据订单唯一编号修改开发者订单号
     * @param orderNum
     * @param developerBizId
     * @return
     */
    public DubboResult<Boolean> updateDeveloperBizId(String orderNum, String developerBizId);
    
    /**
     * 根据订单唯一编号修改加积分开发者订单号
     * @param orderNum
     * @param developerBizId
     * @return
     */
    public DubboResult<Boolean> updateAddDeveloperBizId(String orderNum, String developerBizId);
     
    /**
     * 修改主订单号
     * @param orderNum 订单唯一编号
     * @param mainOrderNum 主订单唯一编号
     * @return
     */
    public DubboResult<Boolean> updateMainOrderNum(String orderNum, String mainOrderNum);
    
    /**
     * 用户参与兑吧活动次数
     * @param consumerId
     * @param duibaActivityId
     * @param activityType
     * @return
     */
    public DubboResult<Integer> findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType);
    
    /**
     * 用户参与兑吧活动订单明细
     * @param consumerId 用户ID
     * @param duibaActivityIds 兑吧活动id集合
     * @param activityType 活动类型
     * @return
     */
    public DubboResult<List<ActivityOrderDto>> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType);
    
    /**
     * 用户时间范围参与兑吧活动订单明细
     * @param consumerId
     * @param duibaActivityId
     * @param activityType
     * @param start
     * @param end
     * @return
     */
    public DubboResult<ActivityOrderDto> findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType, String start, String end);
    
    /**
     * 根据订单号批量查询订单
     * @param consumerId
     * @param orderNums
     * @return
     */
    public DubboResult<List<ActivityOrderDto>> findByInOrderNums(long consumerId, List<String> orderNums);
    
    /**
     * 根据过期时间查询未领奖的活动订单号集合
     * @param expirationTime 过期时间
     * @param activityType 活动类型
     * @return orderNum队列
     */
    public DubboResult<List<String>> findByExpirationTime(String expirationTime, String activityType);
    
    /**
     * 根据参数获取中奖的奖项id集合
     * @param consumerId 消费者id
     * @param appId app的id
     * @param activityType 活动类型
     * @return
     */
    public DubboResult<List<Long>> findOptionIds(Long consumerId, Long appId, String activityType);
    
    /**
     * 根据appId获取活动订单列表--分页
     * @param queryMap 条件参数集合
     * 必传{appId,start,pageSize}
     * 选传{duibaActivityId,startTime,endTime,activityOptionId,activityOptionType,exchangeStatus,consumerId}
     * @return
     */
    DubboResult<List<ActivityOrderDto>> findByAppIdWithPage(Map<String, Object> queryMap);
    
    /**
     * 根据appId获取活动订单数
     * @param queryMap 条件参数集合
     * 必传{appId}
     * 选传{duibaActivityId,startTime,endTime,activityOptionId,activityOptionType,exchangeStatus,consumerId}
     * @return
     */
    DubboResult<Integer> getCountByAppId(Map<String, Object> queryMap);
    
    /**
     * 根据活动ids和appId获取活动失败订单列表
     * @param activityIds 兑吧活动id集合
     * @param appId
     * @return 如[{"failCount":1,"duibaActivityId":105},{"failCount":1,"duibaActivityId":111}]
     */
    DubboResult<List<Map<String,Long>>> findFailByActivity4App(List<Long> activityIds, Long appId);

    /**
     * 根据订单号更新添加的积分
     * @param orderNum 订单号
     * @param credits 积分
     * @return
     */
    DubboResult<Boolean> updateAddCredits(String orderNum, Long credits);
}
