package cn.com.duiba.activity.center.api.remoteservice.gamecommon;


import cn.com.duiba.activity.center.api.dto.common.CustomerGameAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 用户游戏关联表，通过customer_id和game_id关联记录用户所拥有的游戏，以及最近在玩的游戏。
 * @author  : cdm
 * @date    : 2016年10月13日 下午4:16:33
 */
public interface RemoteCustomerGameAppService {
	
    /**
     * 
     * getDtoByGameIdAndCustomerId:(这里用一句话描述这个方法的作用). <br/>
     * 根据用户ID，游戏ID，appID获取用户的游戏记录信息,没有就新增后返回
     * @param gameId
     * @param customerId
     * @param appId
     * @param gameType
     * @return
     * @since JDK 1.6
     */
    DubboResult<CustomerGameAppDto> getDtoByGameIdAndCustomerId(Long gameId, Long customerId, Long appId,Long gameType);
    
    /**
     * 
     * updateRecod:(这里用一句话描述这个方法的作用). <br/>
     * 更新用户游戏记录
     * @param gameId
     * @param customerId
     * @param appId
     * @param bestRecord
     * @param rank
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateRecod(Long gameId, Long customerId, Long appId,Long bestRecord, Long rank);

    /**
     * 
     * updateIsBuy:(这里用一句话描述这个方法的作用). <br/>
     * 更新用户授权信息
     * @param gameId
     * @param customerId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateIsBuy(Long gameId, Long customerId, Long appId);
}

