package cn.com.duiba.activity.center.api.remoteservice.manual;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;

/**
 * 
 * ClassName: RemoteManualOrderLotteryService <br/>
 * date: 2016年12月1日 下午3:42:59 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteManualOrderLotteryService {

    /**
     * 
     * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 
     * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户在时间段内参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start,
                                                           Date end);

    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户免费参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 查询用户在时间段内免费参与活动次数
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start,
                                                               Date end);

    /**
     * 
     * findAllOpenManualLotteryByCondition:(这里用一句话描述这个方法的作用). <br/>
     * 条件搜索开奖记录
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap);

    /**
     * 
     * findAllOpenManualLotteryCount:(这里用一句话描述这个方法的作用). <br/>
     * 条件搜索开奖记录条数
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    Long findAllOpenManualLotteryCount(Map<String, Object> paramMap);

    /**
     * 
     * findWardList:(这里用一句话描述这个方法的作用). <br/>
     * 查询中奖清单
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findWardList(Long operatingActivityId);
    
    /**
     * 
     * findNoWardList:(这里用一句话描述这个方法的作用). <br/>
     * 查询参与清单
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findNoWardList(Map<String, Object> paramMap);

    /**
     * 
     * findNoWardListCount:(这里用一句话描述这个方法的作用). <br/>
     * 查询参与清单count
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    Long findNoWardListCount(Map<String, Object> paramMap);
    
    /**
     * 
     * findStartOpenListByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据ids查询待开奖的用户list
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findStartOpenListByIds(Map<String, Object> paramMap);
    
    /**
     * 
     * updateAward:(这里用一句话描述这个方法的作用). <br/>
     * 更新中奖用户状态
     * @param id
     * @param activityId
     * @param date
     * @return
     * @since JDK 1.6
     */
    int updateAward(Long id, Long activityId, Date date);

    /**
     * 
     * randomFindManualLottery:(这里用一句话描述这个方法的作用). <br/>
     * 随机抽一条
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    ManualLotteryOrderDto randomFindManualLottery(Map<String, Object> paramMap);

    /**
     * 
     * updateNoAwardList:(这里用一句话描述这个方法的作用). <br/>
     * 更新未中奖用户
     * @param paramMap
     * @since JDK 1.6
     */
    void updateNoAwardList(Map<String, Object> paramMap);
    
    /**
     * 
     * findAllNoAwardList:(这里用一句话描述这个方法的作用). <br/>
     * 查询未中奖用户
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findAllNoAwardList(Map<String, Object> paramMap);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 查询所有ids
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<ManualLotteryOrderDto> findAllByIds(List<Long> ids);

    /**
     * 
     * findByOrderId:(这里用一句话描述这个方法的作用). <br/>
     * 根据订单号查询
     * @param orderId
     * @return
     * @since JDK 1.6
     */
    ManualLotteryOrderDto findByOrderId(Long orderId);

    /**
     * 
     * findByAppAndDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * @param appId
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    ManualLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param manualLotteryOrderDto
     * @return
     * @since JDK 1.6
     */
    ManualLotteryOrderDto insert(ManualLotteryOrderDto manualLotteryOrderDto);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param manualLotteryOrderDto
     * @since JDK 1.6
     */
    void update(ManualLotteryOrderDto manualLotteryOrderDto);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    ManualLotteryOrderDto find(Long id);
    
	/**
	 * 开发者手动开奖，确认中奖名单,并进行自动发奖
     * @param activityId
     * @param manualLotteryOrderIds
     * @return
	 */
	public boolean giveAwardList(Long activityId,List<Long> manualLotteryOrderIds);
}
