package cn.com.duiba.activity.center.api.remoteservice.permission;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.permission.PermissionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by zhengjy on 2016/12/13.
 */
public interface RemotePermissionService {

    /**
     * 授权
     * @param operatingActivityId
     * @return
     */
    public DubboResult<Boolean> grantPermissionToOperatingActivity(Long operatingActivityId);

    /**
     * 授权
     * @param operatingActivityId
     * @param sourceType PermissionDto常量
     * @return
     */
    public DubboResult<Boolean> grantPermissionToOperatingActivity(Long operatingActivityId, int sourceType);

    /**
     * 收回活动授权
     *
     * @param operatingActivityId
     */
    public DubboResult<Boolean> revokePermissionToOperatingActivity(Long operatingActivityId);

    public DubboResult<Boolean> revokePermissionToOperatingActivity(Long operatingActivityId, int sourceType);
    
    /**
     * 查询所有
     * findAllPermission:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<PermissionDto>> findAllPermission(Long appId);
}
