package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import com.alibaba.fastjson.JSONObject;

import java.util.Date;
import java.util.List;

/**
 * 集卡配置
 * Created by xiaoxuda on 2017/10/25.
 */
public class CLCardConfigDto extends BaseDto {

    private static final long serialVersionUID = -9206704999666861311L;

    private Long id;
    /**
     * 集卡活动名称
     */
    private String name;
    /**
     * 集卡规则集合（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRuleDto> rules;
    /**
     * 奖项配置（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRewardDto> rewards;
    /**
     * 是否后台自动发奖
     */
    private Boolean autoReward;
    /**
     * 单个用户 中奖限制，用于控制用户可中的奖项类型数量
     */
    private Integer rewardLimit;
    /**
     * 扩展字段，json类型，KV结构存储，所有KEY必须在这个DTO中定义为静态常量
     */
    private JSONObject extra;
    /**
     * 删除状态
     */
    private Boolean deleted;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CLRuleDto> getRules() {
        return rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardDto> getRewards() {
        return rewards;
    }

    public void setRewards(List<CLRewardDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getAutoReward() {
        return autoReward;
    }

    public void setAutoReward(Boolean autoReward) {
        this.autoReward = autoReward;
    }

    public Integer getRewardLimit() {
        return rewardLimit;
    }

    public void setRewardLimit(Integer rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
