package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.CLRewardRuleMatchEnum;
import cn.com.duiba.activity.center.api.enums.RewardTypeEnum;

import java.io.Serializable;
import java.util.List;

/**
 * 奖项配置
 * Created by xiaoxuda on 2017/10/25.
 */
public class CLRewardDto extends BaseDto {
    private static final long serialVersionUID = 7950283593032350516L;
    /**
     * 奖项等级，默认按奖项顺序,数字越小等级越高
     */
    private Integer grade;
    /**
     * 奖项名称
     */
    private String name;
    /**
     * 出奖方式
     */
    private RewardTypeEnum rdType;
    /**
     * 出奖方式关联类型
     */
    private String rlType;
    /**
     * 出奖方式关联ID
     */
    private Long rlId;
    /**
     * 奖品展示图片
     */
    private String prizeImg;
    /**
     * 奖品名称
     */
    private String prizeName;
    /**
     * 奖项匹配规则集合
     */
    private List<Entry> matchs;
    /**
     * 中奖匹配规则
     */
    private CLRewardRuleMatchEnum matchType;
    /**
     * 是否开启数量限制
     */
    private Boolean amountsLimit;
    /**
     * 中奖数量限制(奖项可用库存)
     */
    private Long limitCount;

    static public class Entry implements Serializable {
        private static final long serialVersionUID = -4971741811275564470L;

        private String key;
        private Integer val;

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Integer getVal() {
            return val;
        }

        public void setVal(Integer val) {
            this.val = val;
        }
    }

    public RewardTypeEnum getRdType() {
        return rdType;
    }

    public void setRdType(RewardTypeEnum rdType) {
        this.rdType = rdType;
    }

    public String getRlType() {
        return rlType;
    }

    public void setRlType(String rlType) {
        this.rlType = rlType;
    }

    public Long getRlId() {
        return rlId;
    }

    public void setRlId(Long rlId) {
        this.rlId = rlId;
    }

    public String getPrizeImg() {
        return prizeImg;
    }

    public void setPrizeImg(String prizeImg) {
        this.prizeImg = prizeImg;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public List<Entry> getMatchs() {
        return matchs;
    }

    public void setMatchs(List<Entry> matchs) {
        this.matchs = matchs;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CLRewardRuleMatchEnum getMatchType() {
        return matchType;
    }

    public void setMatchType(CLRewardRuleMatchEnum matchType) {
        this.matchType = matchType;
    }

    public Boolean getAmountsLimit() {
        return amountsLimit;
    }

    public void setAmountsLimit(Boolean amountsLimit) {
        this.amountsLimit = amountsLimit;
    }

    public Long getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Long limitCount) {
        this.limitCount = limitCount;
    }
}
