package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.CLRewardRuleMatchEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 集卡配置
 * Created by xiaoxuda on 2017/10/25.
 */

public class CLCardConfigDto extends BaseDto {

    private static final long serialVersionUID = -9206704999666861311L;

    private Long id;
    /**
     * 集卡活动名称
     */
    private String clName;
    /**
     * 集卡规则集合（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRuleDto> rules;
    /**
     * 奖项配置（大于1000个字符），json结构，大概支持15个数据项配置
     */
    private List<CLRewardDto> rewards;
    /**
     * 是否后台自动发奖
     */
    private Boolean autoReward;
    /**
     * 单个用户 中奖限制，用于控制用户可中的奖项类型数量
     */
    private Integer rewardLimit;
    /**
     * 扩展字段，json类型，KV结构存储，所有KEY必须在这个DTO中定义为静态常量
     */
    private JSONObject extra;
    /**
     * 删除状态
     */
    private Boolean deleted;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 获取给定数据匹配的奖励等级,返回null表示未中奖
     *
     * @param entries
     * @return
     */
    public CLRewardDto getMatchGrade(List<CLRewardDto.Entry> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return null;
        }
        //顺序匹配奖项，匹配到即返回数据位置作为
        for (CLRewardDto dto : rewards) {
            if (matchValid(dto, entries)) {
                return dto;
            }
        }
        return null;
    }

    /**
     * 奖项匹配
     * @param reward
     * @param entries
     * @return
     */
    public boolean matchValid(CLRewardDto reward, List<CLRewardDto.Entry> entries){
        if(CLRewardRuleMatchEnum.ALL_MATCH.equals(reward.getMatchType())){
            return allMatchValid(reward, entries);
        }
        return false;
    }

    /**
     * 全匹配类型--中奖判断
     * @param reward
     * @param entries
     * @return
     */
    private boolean allMatchValid(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(CLRewardDto.Entry entry : entries){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for(CLRewardDto.Entry rule : reward.getMatchs()){
            Integer val = paramMap.get(rule.getKey());
            if(val == null || val < rule.getVal()){
                return false;
            }
        }
        return true;
    }

    /**
     * 用卡片对换奖项
     * @param reward
     * @param entries
     */
    public void matchDeduct(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        if(CLRewardRuleMatchEnum.ALL_MATCH.equals(reward.getMatchType())){
            allMatchDeduct(reward, entries);
        }
    }

    /**
     * 全匹配类型--用卡片对换奖项
     * @param reward
     * @param entries
     */
    private void allMatchDeduct(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(CLRewardDto.Entry entry : reward.getMatchs()){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for(CLRewardDto.Entry rule : entries){
            Integer val = paramMap.get(rule.getKey());
            if(val != null) {
                rule.setVal(rule.getVal() - val);
            }
        }
    }

    /**
     * 根据给定的集卡结果获取中奖奖项及奖项对应的数量
     * @param entries
     * @return K-V(CLRewardDto.getGradle,Num)
     */
    public Map<Integer, Integer> getMatchGradeMap(List<CLRewardDto.Entry> entries) {
        Map<Integer, Integer> result = new HashMap<>();
        List<CLRewardDto.Entry> entriesCopy = BeanUtils.copyList(entries, CLRewardDto.Entry.class);
        //顺序匹配奖项，匹配到即返回数据位置作为
        for (CLRewardDto dto : rewards) {
            int matchCount = 0;
            while(matchValid(dto, entriesCopy)){
                ++matchCount;
                matchDeduct(dto, entriesCopy);
            }
            result.put(dto.getGrade(), matchCount);
        }
        return result;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClName() {
        return clName;
    }

    public void setClName(String clName) {
        this.clName = clName;
    }

    public List<CLRuleDto> getRules() {
        return rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardDto> getRewards() {
        return rewards;
    }

    public void setRewards(List<CLRewardDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getAutoReward() {
        return autoReward;
    }

    public void setAutoReward(Boolean autoReward) {
        this.autoReward = autoReward;
    }

    public Integer getRewardLimit() {
        return rewardLimit;
    }

    public void setRewardLimit(Integer rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
