/**
 * Project Name:activity-center-api File Name:RemoteShieldBackendService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.gamecenter Date:2016年10月18日下午8:22:09 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.api.remoteservice.gamecenter;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteShieldBackendService <br/>
 * Function: 黑名单后台服务. <br/>
 * Reason: 编辑功能只有后台服务才使用. <br/>
 * Date: 2016年10月18日 下午8:22:09 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface RemoteShieldBackendService {

    /**
     * addShield:屏蔽活动. <br/>
     *
     * @author zhuzhiyong
     * @param shieldItemDto the shield item dto
     * @return the dubbo result
     * @since JDK 1.6
     */
    DubboResult<Long> addShield(ShieldItemDto shieldItemDto);

    /**
     * removeFromBlacklist:批量还原屏蔽的活动. <br/>
     *
     * @author zhuzhiyong
     * @param shieldId the shield id
     * @return the dubbo result
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeShield(Long shieldId);

    /**
     * isExist:查询屏蔽记录, 屏蔽返回true, 未屏蔽返回false. <br/>
     * activityType定义在{@code DefinedActivityTypesDto}
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param activityType the activity type
     * @param activityId the activity id
     * @return the dubbo result
     */
    DubboResult<Boolean> isExist(Long appId, Integer activityType, Long activityId);
}
