package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolBackendDto;


/** 
 * ClassName:RemoteDuibaHdtoolBackendService.java <br/>
 * 
 * duiba 活动工具  管理员端用  接口  
 * 
 * 该接口提供 管理员端 数据查询（之前数据全表扫描  现在改为 只查询列表页显示数据 ）
 * RemoteDuibaHdtoolServiceNew  杂糅了 很多其他功能  这次修改不去 该院有功能  等新接口稳定后 旧接口可以直接下线
 * 
 * 手机端 不可以调用该接口可能存在性能问题
 * 
 * @author  gey 
 * @date 创建时间：2017年11月3日 上午11:11:43 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface RemoteDuibaHdtoolBackendService {

	/**
	 * 
	 * findDuibaHdToolsList:(这里用一句话描述这个方法的作用). <br/>
	 * 活动工具分页列表
	 * @param paramMap
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaHdtoolBackendDto> findDuibaHdToolsList(Map<String, Object> paramMap);
	
	/**
	 * 
	 * countDuibaHdToolsList:(这里用一句话描述这个方法的作用). <br/>
	 * 统计活动工具条数
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap);

	/**
	 * 
	 * countAppByActivityIdAndType:(查询开启app数量). <br/>
	 * 
	 * @param activityId
	 * @param type
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countAppByActivityIdAndType(Long activityId, String subType);
}
