package cn.com.duiba.activity.center.api.remoteservice.rob;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
/**
 * RemoteTodayRobSeckillBackendService <br/>
 * Function: 今日必抢的免单秒杀 <br/>
 * Date: 2016年9月30日 上午8:53:28 <br/>
 * 
 * @author zhengjy
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteTodayRobSeckillBackendService {
	/**
	 * 查询秒杀区间下秒杀活动列表
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	DubboResult<List<TodayRobSeckillConfigDto>> findSeckillConfigs(Long todayRobSeckillId);
	
	/**
	 * 查询秒杀区间Dto
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	DubboResult<TodayRobSeckillDto> findSeckillById(Long todayRobSeckillId);
	
	/**
	 * 批量插入秒杀配置项  秒杀活动
	 * @deprecated  seveSeckillConfigs
	 * @param list
	 * @param todayRobSeckillDto
	 * @return
	 */
	@Deprecated
	DubboResult<Boolean>  seveSeckillConfigs(List<TodayRobSeckillConfigDto> list,TodayRobSeckillDto todayRobSeckillDto);
	
	/**
     * 批量插入秒杀配置项  秒杀活动
     * @param list 秒杀区间配置活动
     * @param todayRobSeckillDto 秒杀区间
     * @return 秒杀区间主键
     */
	DubboResult<Long>  saveSeckillConfigs(List<TodayRobSeckillConfigDto> list,TodayRobSeckillDto todayRobSeckillDto);
	
	/**
     * 分页查询秒杀区间列表
     *@deprecated findTodayRobSeckillList
     * @param pageNum  第几页
     * @param pageSize 每页展示数量
     * @return
     */
	@Deprecated
    DubboResult<PaginationDto<TodayRobSeckillListDto>> findTodayRobSeckillList(int pageNum, int pageSize);

	/**
	 *  * 分页查询秒杀区间列表
	 *
	 * @param pageNum  第几页
	 * @param pageSize 每页展示数量
	 * @param todayRobSeckillDto
     * @return
     */
	DubboResult<PaginationDto<TodayRobSeckillListDto>> findTodayRobSeckillList(int pageNum, int pageSize,TodayRobSeckillDto todayRobSeckillDto);
	

    /**
     * 删除秒杀区间
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @return
     */
    DubboResult<Boolean> delTodayRobSeckill(long todayRobSeckillId);
	
	
    /**
     * 停用/启用秒杀区间
     * 启动时，需要扫描秒杀活动是否推送过，没有推送需要推送到开发库
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @param enable  true-启用；false-停用
     * @return
     */
    DubboResult<Boolean> enableTodayRobSeckill(long todayRobSeckillId, boolean enable);
    
    /**
     * 更新推送APP列表
     *
     * @author zhanglihui
     * @param appIdList appId列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> updatePushApps(List<Long> appIdList);
}
