/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.dto.sign.SignRewardRuleDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRuleItemDto;
import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public enum SignRewardTypeEnum {
    CONTINUE(1, "\u8fde\u7eed\u5956\u52b1"){

        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay > circle ? circle : continueDay;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    CIRCLE(2, "\u5468\u671f\u5956\u52b1"){

        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay % circle;
            index = index == 0 ? circle : index;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    ACCUMULATE(3, "\u7d2f\u8ba1\u5956\u52b1"){

        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            for (SignRuleItemDto item : rewardRule.getItems()) {
                if (item.getDays() == null || !Objects.equals(item.getDays(), continueDay)) continue;
                return item;
            }
            return new SignRuleItemDto();
        }
    }
    ,
    SPEC_DAY(4, "\u7279\u6b8a\u65e5\u671f\u5956\u52b1"){

        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            return new SignRuleItemDto();
        }
    };

    private Integer code;
    private String desc;

    private SignRewardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public SignRuleItemDto getRuleItem(Integer continueDay, SignRewardRuleDto rewardRule) {
        if (continueDay < 0 || rewardRule == null) {
            throw new ActivityCenterException("\u53c2\u6570\u975e\u6cd5");
        }
        if (!Boolean.TRUE.equals(rewardRule.getOpen()) || CollectionUtils.isEmpty(rewardRule.getItems())) {
            return new SignRuleItemDto();
        }
        return this.getRuleItemSub(continueDay, rewardRule);
    }

    protected abstract SignRuleItemDto getRuleItemSub(int var1, SignRewardRuleDto var2);

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

