/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.dto.sign.SignRewardConfigDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRewardRuleDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRuleConfigDto;
import cn.com.duiba.activity.center.api.dto.sign.system.SignActivityDto;
import cn.com.duiba.activity.center.api.enums.CustomCircleTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignRewardTypeEnum;
import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum SignTypeEnum {
    CONTINUE(0, "\u8fde\u7eed\u7b7e\u5230"),
    CIRCLE(1, "\u8fde\u7eed\u5468\u671f\u7b7e\u5230"){

        @Override
        public Integer getContinueDayInCircle(SignActivityDto activity, int continueDay, boolean todaySigned, Date signDate) {
            int cirDays = this.getCircleDays(activity);
            int days = continueDay % cirDays;
            continueDay = days == 0 && continueDay >= cirDays ? (!todaySigned ? 0 : cirDays) : days;
            return continueDay;
        }

        @Override
        public Integer getCircleDays(SignActivityDto activity) {
            SignRuleConfigDto ruleConfig = activity.getSignRuleConfig();
            int cirDays = 1;
            if (ruleConfig.getCusCirDays() != null) {
                cirDays = ruleConfig.getCusCirDays();
            } else {
                SignRewardConfigDto signRewardConfig = activity.getSignRewardConfig();
                SignRewardRuleDto reward = signRewardConfig.getRwRules().get((Object)SignRewardTypeEnum.CIRCLE);
                if (reward != null) {
                    cirDays = reward.getItems().size();
                }
            }
            return cirDays;
        }
    }
    ,
    CUSTOM(2, "\u81ea\u5b9a\u4e49\u7b7e\u5230"),
    CUSTOM_CIRCLE(4, "\u81ea\u5b9a\u4e49\u5468\u671f"){

        @Override
        public Calendar getCirStartDate(SignActivityDto activity) {
            SignRuleConfigDto config = activity.getSignRuleConfig();
            Calendar today = Calendar.getInstance();
            Calendar cusCirStart = Calendar.getInstance();
            cusCirStart.setTime(config.getCusCirStart());
            Calendar startDate = Calendar.getInstance();
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)config.getCusCirType())) {
                int cirNum = (DateUtils.daysBetween((Date)cusCirStart.getTime(), (Date)today.getTime()) + 1) % config.getCusCirDays();
                if (cirNum == 0) {
                    startDate.setTime(DateUtils.daysAddOrSub((Date)today.getTime(), (int)(1 - config.getCusCirDays())));
                } else {
                    startDate.setTime(DateUtils.daysAddOrSub((Date)today.getTime(), (int)(1 - cirNum)));
                }
            } else if (CustomCircleTypeEnum.MONTH.equals((Object)config.getCusCirType())) {
                int dayGap = today.get(5) - cusCirStart.get(5);
                startDate.set(5, cusCirStart.get(5));
                if (dayGap < 0) {
                    startDate.setTime(DateUtils.monthsAddOrSub((Date)startDate.getTime(), (int)-1));
                }
            }
            return startDate;
        }

        @Override
        public Calendar getCirEndDate(Calendar start, SignActivityDto activity) {
            SignRuleConfigDto config = activity.getSignRuleConfig();
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(start.getTime());
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)config.getCusCirType())) {
                endDate.set(5, start.get(5) + config.getCusCirDays() - 1);
            } else if (CustomCircleTypeEnum.MONTH.equals((Object)config.getCusCirType())) {
                endDate.set(5, endDate.getActualMaximum(5));
            }
            return endDate;
        }

        @Override
        public Integer getCircleDays(SignActivityDto activity) {
            SignRuleConfigDto config = activity.getSignRuleConfig();
            if (CustomCircleTypeEnum.FIXED_DAYS.equals((Object)config.getCusCirType())) {
                return config.getCusCirDays();
            }
            if (CustomCircleTypeEnum.MONTH.equals((Object)config.getCusCirType())) {
                return this.getCirStartDate(activity).getActualMaximum(5);
            }
            return super.getCircleDays(activity);
        }

        @Override
        public Integer getContinueDayInCircle(SignActivityDto activity, int continueDay, boolean todaySigned, Date signDate) {
            Calendar today = Calendar.getInstance();
            Calendar startDate = this.getCirStartDate(activity);
            Calendar endDate = this.getCirEndDate(startDate, activity);
            int days = DateUtils.daysBetween((Date)this.getCirStartDate(activity).getTime(), (Date)today.getTime()) + 1;
            int daysNextCir = DateUtils.daysBetween((Date)endDate.getTime(), (Date)signDate);
            if (daysNextCir > 0) {
                days = daysNextCir;
            } else {
                daysNextCir = DateUtils.daysBetween((Date)today.getTime(), (Date)signDate);
                if (daysNextCir > 0) {
                    days += daysNextCir;
                }
            }
            if (continueDay >= days) {
                continueDay = days;
                if (!todaySigned) {
                    --continueDay;
                }
            }
            return continueDay;
        }
    };

    private static Map<Integer, SignTypeEnum> typeEnumMap;
    private Integer code;
    private String desc;

    public static SignTypeEnum getByCode(int code) {
        SignTypeEnum type = typeEnumMap.get(code);
        if (type == null) {
            throw new ActivityCenterException("\u4e0d\u652f\u6301\u7684\u7b7e\u5230\u7c7b\u578b");
        }
        return type;
    }

    private SignTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Calendar getCirStartDate(SignActivityDto activity) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1 - this.getCircleDays(activity));
        return calendar;
    }

    public Calendar getCirEndDate(Calendar start, SignActivityDto activity) {
        return Calendar.getInstance();
    }

    public Integer getCircleDays(SignActivityDto activity) {
        return 31;
    }

    public Integer getContinueDayInCircle(SignActivityDto activity, int continueDay, boolean todaySigned, Date signDate) {
        return continueDay;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeEnumMap = new HashMap<Integer, SignTypeEnum>();
        for (SignTypeEnum typeEnum : SignTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }
}

