package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.enums.SignRewardTypeEnum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 签到奖励配置
 * Created by xiaoxuda on 2017/11/14.
 */
public class SignRewardConfigDto implements Serializable {
    private static final long serialVersionUID = 7457954542173827278L;

    /**
     * 规则集合
     */
    private Map<SignRewardTypeEnum, SignRewardRuleDto> rwRules = new HashMap<>();

    public void putToRwRules(SignRewardRuleDto reward){
        if(rwRules == null){
            rwRules = new HashMap<>();
        }
        rwRules.put(reward.getRwType(), reward);
    }

    public Map<SignRewardTypeEnum, SignRewardRuleDto> getRwRules() {
        return rwRules;
    }

    public void setRwRules(Map<SignRewardTypeEnum, SignRewardRuleDto> rwRules) {
        this.rwRules = rwRules;
    }
}
