package cn.com.duiba.activity.center.api.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 集卡熟悉枚举
 * Created by gey on 2017/12/08.
 */
public enum CLRewardRuleTypeEnum {

    PLUS_MULTIPLE("plus_multiple","增加倍数"),
    REDUCE_MULTIPLE("reduce_multiple","减少倍数"),
    PLUS_SCORE("plus_score","增加分数"),
    REDUCE_SCORE("reduce_score","减少分数");

    /**
     * key
     */
    private String key;
    /**
     * 描述
     */
    private String name;
    private static List<CLRewardRuleTypeEnum> list = Lists.newArrayList();

    CLRewardRuleTypeEnum(String key ,String name){
        this.key = key;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getKey() {
        return key;
    }

    static{
        for(CLRewardRuleTypeEnum typeClass : CLRewardRuleTypeEnum.values()){
            list.add(typeClass);
        }
    }

    /**
     * 获取全部 枚举值和名称
     * @return
     */
    public static List<CLRewardRuleTypeEnum> getAll(){
        return list;
    }
}
