package cn.com.duiba.activity.center.api.tool;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br/>
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 * 
 * @author houwen
 */
public enum RedisKeySpace {
	/** 活动每日参与次数 */
	K001("活动每日参与次数"),
	/** 活动每日免费次数 */
	K002("活动每日免费次数"),
	/**签到体系活动签到锁key**/
	K003("签到体系活动签到锁key"),
	/**活动工具皮肤默认数据key**/
	K004("活动工具皮肤默认数据"),
	/**入库活动缓存key**/
	K005("入库活动缓存key"),
	/**更新签到统计数据锁**/
	K006("更新签到统计数据锁key"),
	/**插件活动dto缓存key**/
	K007("插件活动dto缓存key"),
	/**客服配置缓存key**/
	K008("客服配置缓存key"),
	/**活动奖品发放数量**/
	K009("活动奖品发放数量"),
	/**集卡发奖用户锁,用户奖项扣库存时对用户枷锁避免任何的数据变更引起的奖项超发**/
	K010("集卡发奖用户锁"),
	/**多游戏排名基本配置**/
	K011("多游戏排名基本配置"),
	/**多游戏排名一个配置下面的活动列表**/
	K012("多游戏排名一个配置下面的活动列表"),
	/**多游戏排名中一个活动对应的配置项id**/
	K013("多游戏排名中一个活动对应的配置项id")
	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "AC";

	private String desc;

	RedisKeySpace(String description) {
		this.desc = description;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 拼接key前置
	 */
	@Override
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}