package cn.com.duiba.activity.center.api.remoteservice.group;

import cn.com.duiba.activity.center.api.dto.group.GroupActivityRecordDto;
import cn.com.duiba.activity.center.api.dto.group.GroupCountDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @description: 组团活动远程服务
 * @author: zhengwei
 * @date: 2018-08-08 20:15
 */
@AdvancedFeignClient
public interface RemoteGroupActivityService {
    /**
     * 获取用户组团活动数据
     * @param appId
     * @param activityId
     * @param partnerId
     * @return
     */
    GroupActivityRecordDto find(Long appId, Long activityId, String partnerId);

    /**
     * 团队维度人数统计
     * @param appId
     * @param activityId
     * @param teamId
     * @return
     */
    GroupCountDto countTeam(Long appId, Long activityId, String teamId);

    /**
     * 更新开发者用户组团活动数据
     * @param dto
     * @return
     */
    Boolean update(GroupActivityRecordDto dto);

    /**
     * 插入开发者用户组团活动数据
     * @param dto
     * @return
     */
    Boolean insert(GroupActivityRecordDto dto);
}
