package cn.com.duiba.activity.center.api.remoteservice.singlelottery;


import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryStockConsumeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;

/**
 * 单品抽奖库存消费
 * @author zp
 *
 */
@AdvancedFeignClient
public interface RemoteSingleLotteryStockConsumeService {

    /**
     * 
     * consumeDuibaSingleLotteryStock:(这里用一句话描述这个方法的作用). <br/>
     * 兑吧单品抽奖消费库存,大奖，小奖
     * @param duibaSingleLotteryId
     * @param appId
     * @param optionType
     * @param bizId
     * @param bizSource
     * @throws BusinessException
     * @since JDK 1.6
     */
	public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId, Long appId, Integer optionType, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * paybackDuibaSingleLotteryStock:(这里用一句话描述这个方法的作用). <br/>
	 * 返单品抽奖消费库存，大奖，小奖
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void paybackDuibaSingleLotteryStock(String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * consumeSingleLotterySpecifyStock:(这里用一句话描述这个方法的作用). <br/>
	 * 消费兑吧单品定向库存
	 * @param duibaSingleLotteryId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * paybackSingleLotterySpecifyStock:(这里用一句话描述这个方法的作用). <br/>
	 * 返兑吧单品定向库存
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void paybackSingleLotterySpecifyStock(String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * consumeDevSingleLotteryStock:(这里用一句话描述这个方法的作用). <br/>
	 * 开发者自有单品抽奖消费库存，大奖
	 * @param appSingleLotteryId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void consumeDevSingleLotteryStock(Long appSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException;
	
	/**
	 * 
	 * pabackDevSingleLoteryStock:(这里用一句话描述这个方法的作用). <br/>
	 * 返开发者单品抽奖消费库存，大奖
	 * @param bizId
	 * @param bizSource
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	public void pabackDevSingleLoteryStock(String bizId, String bizSource) throws BusinessException;

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * @param singleLotteryStockConsumeDto
	 * @return
	 * @since JDK 1.6
	 */
	public SingleLotteryStockConsumeDto insert(SingleLotteryStockConsumeDto singleLotteryStockConsumeDto);

	/**
	 * 
	 * findByBizIdAndSource:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param bizId
	 * @param bizSource
	 * @return
	 * @since JDK 1.6
	 */
	public SingleLotteryStockConsumeDto findByBizIdAndSource(String bizId, String bizSource);
}
