package cn.com.duiba.activity.center.api.dto.hdtool;

import cn.com.duiba.activity.center.api.dto.BaseActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 兑吧活动工具
 * 
 * @author houwen
 */
public class DuibaHdtoolDto extends BaseActivityDto implements Serializable {
	private static final long serialVersionUID = -1692595446834739092L;

	public static final int STATUS_NOCOMPLETE = 0; // 数据不完整
	public static final int STATUS_OPEN = 1; // 开启且可见
	public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
	public static final int STATUS_CLOSE = 3; // 关闭不可见
	public static final int STATUS_CLOSE_READY_ON = 4; // 关闭不可见，即将自动上架

	public static final String LimitTypeForever = "forever"; // 永久
	public static final String LimitTypeEveryday = "everyday"; // 每天

	//积分模式
	public static final int CreditsTypeNo = 0; // 无积分模式
	public static final int CreditsTypeYes = 1; // 有积分模式
	//SWITCHES 开关
	public static final int SWITCHES_DIRECT = 0;//定向发放
	public static final int SWITCHES_DEV_BLACKLIST = 1;//黑名单
	public static final int SWITCHES_FREE_RULE = 2; // 免费次数使用的活动规则
	public static final int SWITCHES_NEW = 3;//判断是否是新添加的活动-与管理员端保持一样用3,新添加活动大奖默认开启库存预分配功能
	public static final int SWITCHES_NEW_HDTOOL = 4;//判断是否是新的活动工具
	public static final Integer ANTICHEAT_LIMIT_RULE = 5; // 开启直充类奖品防刷
	public static final int SWITCHES_NEW_ABTEST = 6;//活动工具是否开启 ab test
	/**
	 * 开启多奖项限制
	 */
	public static final int SWITCHES_NEW_OPEN_MUTLI_PRIZE_LIMIT = 7;
	public static final int SWITCHES_PRIZES_GRANT_LIMIT = 8;//奖品发放限制
	public static final int SWITCHES_PRIZES_GUESS = 9;//竞猜是否开奖
	
	public static final int TYPE_SHAKE = 1;//摇一摇抽奖
	public static final int TYPE_SCRATCH = 2;//刮刮乐
	public static final int TYPE_TURNTABLE = 3;//大转盘
	public static final int TYPE_TIGER = 4;//老虎机,
	public static final int TYPE_FLOP = 5;//趣味翻牌
	public static final int TYPE_SMASHG = 6;//砸彩蛋

	//Start chaijiangang,幸运转盘改为活动工具,2016/04/12
	public static final String TYPE_SHAKE_Action = "shake";//摇一摇抽奖
	public static final String TYPE_SCRATCH_Action = "ScratchCard";//刮刮乐
	public static final String TYPE_TURNTABLE_Action = "turntableNew";//大转盘
	public static final String TYPE_TIGER_Action = "tiger";//老虎机
	public static final String TYPE_FLOP_Action = "flop";//趣味翻牌
	public static final String TYPE_SMASHG_Action = "smashg";//砸彩蛋
	//End chaijiangang,幸运转盘改为活动工具,2016/04/12

	public static final String TYPE_CUSTOM_ACTION = "custom";//自定义活动工具 20170803

	/**
	 * extendJson扩展json字段key定义：多奖项限制次数
	 */
	public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_COUNT = "mutliPrizeLimitCount";
	/**
	 * extendJson扩展json字段key定义：多奖项限制id列表
	 */
	public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_IDS = "mutliPrizeLimitIds";
	/**
	 * extendJson扩展json字段key定义：闯关模式
	 */
	public static final String EXT_JSON_KEY_THROUGH_MODE = "through_mode";
	/**
	 * extendJson扩展json字段key定义：关卡数
	 */
	public static final String EXT_JSON_KEY_THROUGH_NUM = "through_num";
	/**
	 * extendJson扩展json字段key定义：奖品兑换限制天数(旧版)
	 */
	public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS = "prizesGrantLimitDays";
	/**
	 * extendJson扩展json字段key定义：奖品兑换限制天数(新版)
	 */
	public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS = "prizesGrantLimitNewDays";
	/**
	 * extendJson扩展json字段key定义：各奖品兑换限制数量
	 */
	public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NUMS = "prizesGrantLimitNum";
	/**
	 * extendJson扩展json字段key定义：直冲类奖项防刷类型 0：每日一次  1：永久一次
	 */
	public static final String EXT_JSON_KEY_ANTI_CHEAT_EXCHANGE_TYPE = "anticheatExchangeType";
	/**
	 * 闯关模式
	 */
	public static final int THROUGH_MODE = 1;
	/**
	 * 自由模式
	 */
	public static final int THROUGH_MODE_FREE = 2;
	/**
	 * 单关循环
	 */
	public static final int THROUGH_MODE_CYCLE = 3;

	public static final ImmutableSet<Integer> hdtoolSet = ImmutableSet.of(TYPE_SHAKE,TYPE_SCRATCH,TYPE_TURNTABLE,TYPE_TIGER,TYPE_FLOP,TYPE_SMASHG);


	private Long id;
	private String title;
	private Integer type;
	private String subType;
	private Integer creditsType;
	private Long creditsPrice;
	private Integer freeLimit;
	private String freeScope;
	private Integer limitCount;
	private String limitScope;
	private String description;
	private String image;
	private String bannerImage;
	private String smallImage;
	private String whiteImage;
	private String logo;
	private Integer switches;
	private Integer status;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;

	private String rateIntroduction;	// 概率说明
	private Date autoOffDate; //定时自动下架日期
	private Date autoOnDate; //定时自动上架日期
	private String recommendImage; // 推荐位横幅图
	private String freeRule;
	private Long activityCategoryId;//活动分类
	private String tag;
	private Byte activityActionType;//普通活动：0；商业化活动：1
	//皮肤id
	private Long duibaBrickId;
	//扩展字段1
	private String extendJson;
	//出奖方式
	private String factoryKey;
	//是否对开发者隐藏
	private Boolean hiddenForDeveloper;
	//加次数限制
	private Integer addTimeLimit;

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolDto.
	 *
	 */
	public DuibaHdtoolDto() {
		super();
	}

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolDto.
	 *
	 * @param id
	 */
	public DuibaHdtoolDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 
	 * Creates a new instance of DuibaHdtoolDto.
	 *
	 * @param init4insert
	 */
	public DuibaHdtoolDto(boolean init4insert) {
		if (init4insert) {
			status = OperatingActivityDto.StatusIntNoComplete;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = tag;
    }
	
    /**
     * 
     * openSwitch:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param s
     * @since JDK 1.6
     */
	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	/**
	 * 
	 * closeSwitch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param s
	 * @since JDK 1.6
	 */
	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	/**
	 * 
	 * isOpenSwitch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param s
	 * @return
	 * @since JDK 1.6
	 */
	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public Integer getCreditsType() {
		return creditsType;
	}

	public void setCreditsType(Integer creditsType) {
		this.creditsType = creditsType;
	}

	public Long getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Long creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getFreeScope() {
		return freeScope;
	}

	public void setFreeScope(String freeScope) {
		this.freeScope = freeScope;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}

	public String getFreeRule() {
		return freeRule;
	}

	public void setFreeRule(String freeRule) {
		this.freeRule = freeRule;
	}

	public Long getDuibaBrickId() {
		return duibaBrickId;
	}

	public void setDuibaBrickId(Long duibaBrickId) {
		this.duibaBrickId = duibaBrickId;
	}

	public String getExtendJson() {
		return extendJson;
	}

	public void setExtendJson(String extendJson) {
		this.extendJson = extendJson;
	}

	public String getFactoryKey() {
		return factoryKey;
	}

	public void setFactoryKey(String factoryKey) {
		this.factoryKey = factoryKey;
	}

	public Date getAutoOnDate() {
		return autoOnDate;
	}

	public void setAutoOnDate(Date autoOnDate) {
		this.autoOnDate = autoOnDate;
	}

	/**
	 * 
	 * getPreviewAction:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public String getPreviewAction() {
		
		switch (this.type) {
		case TYPE_SHAKE: // 摇一摇 ok
			return TYPE_SHAKE_Action;
		case TYPE_SCRATCH: // 刮刮卡 ok
			return TYPE_SCRATCH_Action;
		case TYPE_TURNTABLE: // 活动工具大转盘 ok
			return TYPE_TURNTABLE_Action;
		case TYPE_TIGER: // 老虎机 ok
			return TYPE_TIGER_Action;
		case TYPE_FLOP: // 趣味翻牌 ok
            return TYPE_FLOP_Action;
		case TYPE_SMASHG: // 砸彩蛋 ok
            return TYPE_SMASHG_Action;
		default:
			return "";
		}
	}
	
	public boolean isHdTool(){
	    switch (this.type) {
            case TYPE_SHAKE:
            case TYPE_SCRATCH:
            case TYPE_TURNTABLE:
            case TYPE_TIGER:
            case TYPE_FLOP:
            case TYPE_SMASHG:
                return true;
			default:return false;
        }
	}
	//End chaijiangang,幸运转盘改为活动工具,2016/04/12

	/**
	 * hdTypeToOperType:hdtool表里的type转成operating_activity表中定义的type. <br/>
	 * @author wubo
	 * @param type
	 * @return
	 * @since JDK 1.6
	 */
	public static Integer hdTypeToOperType(Integer type){
	    Integer operatingType;
	    switch(type){
	        case TYPE_SHAKE:
	            operatingType=OperatingActivityDto.TypeShakeLottery;
	            break;
	        case TYPE_SCRATCH:
	            operatingType=OperatingActivityDto.TypeScratchCard;
	            break;
	        case TYPE_TURNTABLE:
	            operatingType=OperatingActivityDto.TypeHdToolTurntable;
	            break;
	        case TYPE_TIGER:
	            operatingType=OperatingActivityDto.TypeHdToolTiger;
	            break;
	        case TYPE_FLOP:
	            operatingType=OperatingActivityDto.TypeHdToolFlop;
	            break;
	        case TYPE_SMASHG:
	            operatingType=OperatingActivityDto.TypeHdToolSmashg;
	            break;
	        default: 
	            operatingType = null;
	            break;
	    }
	    return operatingType;
	}
    public Long getActivityCategoryId() {
        return activityCategoryId;
    }
    
    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }
    
    public Byte getActivityActionType() {
        return activityActionType;
    }
    
    public void setActivityActionType(Byte activityActionType) {
        this.activityActionType = activityActionType;
    }

	public Boolean getHiddenForDeveloper() {
		return hiddenForDeveloper;
	}

	public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
		this.hiddenForDeveloper = hiddenForDeveloper;
	}

	public Integer getAddTimeLimit() {
		return addTimeLimit;
	}

	public void setAddTimeLimit(Integer addTimeLimit) {
		this.addTimeLimit = addTimeLimit;
	}

	/**
	 * 获取最新发奖限制天数
	 * 兼容旧版本1每日,7自然周,30自然月
	 * 改成天数：>0数字；自然周：-1；自然月：-2
	 * 之前没设置好，流下了悔恨的泪水，过度后可删除
	 * @param jsonObject
	 * @return
     */
	public static Integer changeLimitDays2New (JSONObject jsonObject){
		if(jsonObject.get(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS)!=null){
			return jsonObject.getInteger(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS);
		}

		//旧版发奖限制天数(1每日,7每周,30每月)
		Integer prizesGrantLimitDays = jsonObject.getInteger(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS);
		if(Objects.equals(prizesGrantLimitDays,7)){
			return -1;
		}else if(Objects.equals(prizesGrantLimitDays,30)){
			return -2;
		}
		return prizesGrantLimitDays;
	}
}
